/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.AssertionFailure;
import cirrus.hibernate.Databinder;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.Interceptor;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.QueryException;
import cirrus.hibernate.Session;
import cirrus.hibernate.SessionFactory;
import cirrus.hibernate.cache.Timestamper;
import cirrus.hibernate.connection.ConnectionProvider;
import cirrus.hibernate.connection.ConnectionProviderFactory;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.helpers.JDBCExceptionReporter;
import cirrus.hibernate.helpers.PropertiesHelper;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.id.IdentifierGenerator;
import cirrus.hibernate.id.UUIDHexGenerator;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.impl.DatastoreImpl;
import cirrus.hibernate.impl.SessionFactoryObjectFactory;
import cirrus.hibernate.impl.SessionImpl;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.metadata.ClassMetadata;
import cirrus.hibernate.metadata.CollectionMetadata;
import cirrus.hibernate.persister.ClassPersister;
import cirrus.hibernate.persister.EntityPersister;
import cirrus.hibernate.persister.MultiTableEntityPersister;
import cirrus.hibernate.persister.Queryable;
import cirrus.hibernate.ps.PreparedStatementCache;
import cirrus.hibernate.query.FilterTranslator;
import cirrus.hibernate.query.QueryTranslator;
import cirrus.hibernate.sql.Dialect;
import cirrus.hibernate.sql.GenericDialect;
import cirrus.hibernate.transaction.JDBCTransactionFactory;
import cirrus.hibernate.transaction.TransactionFactory;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.xml.XMLDatabinder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SessionFactoryImpl
implements SessionFactory,
SessionFactoryImplementor {
    private final String name;
    private final String uuid;
    private final transient Map classPersisters;
    private final transient Map classPersistersByName;
    private final transient Map collectionPersisters;
    private final transient Map namedQueries;
    private final transient ConnectionProvider connections;
    private final transient Properties properties;
    private final transient boolean showSql;
    private final transient boolean useOuterJoin;
    private final transient boolean supportsLocking;
    private final transient Templates templates;
    private final transient Map querySubstitutions;
    private final transient String[] queryImports;
    private final transient Dialect dialect;
    private final transient PreparedStatementCache stCache;
    private final transient TransactionFactory transactionFactory;
    private final transient int jdbcBatchSize;
    private final transient boolean useScrollableResultSets;
    private final transient String defaultSchema;
    private final transient Integer statementFetchSize;
    private final transient Interceptor interceptor;
    private static final IdentifierGenerator uuidgen = new UUIDHexGenerator();
    private static final Class[] PERSISTER_CONSTRUCTOR_ARGS = new Class[]{class$cirrus$hibernate$map$PersistentClass == null ? (class$cirrus$hibernate$map$PersistentClass = SessionFactoryImpl.class$("cirrus.hibernate.map.PersistentClass")) : class$cirrus$hibernate$map$PersistentClass, class$cirrus$hibernate$engine$SessionFactoryImplementor == null ? (class$cirrus$hibernate$engine$SessionFactoryImplementor = SessionFactoryImpl.class$("cirrus.hibernate.engine.SessionFactoryImplementor")) : class$cirrus$hibernate$engine$SessionFactoryImplementor};
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$impl$SessionFactoryImpl == null ? (class$cirrus$hibernate$impl$SessionFactoryImpl = SessionFactoryImpl.class$("cirrus.hibernate.impl.SessionFactoryImpl")) : class$cirrus$hibernate$impl$SessionFactoryImpl));
    private final transient ReferenceMap queryCache = new ReferenceMap(1, 1);
    static /* synthetic */ Class class$cirrus$hibernate$map$PersistentClass;
    static /* synthetic */ Class class$cirrus$hibernate$engine$SessionFactoryImplementor;
    static /* synthetic */ Class class$cirrus$hibernate$impl$SessionFactoryImpl;
    static /* synthetic */ Class class$cirrus$hibernate$persister$EntityPersister;
    static /* synthetic */ Class class$cirrus$hibernate$persister$MultiTableEntityPersister;
    static /* synthetic */ Class class$cirrus$hibernate$impl$SessionFactoryObjectFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactoryImpl(DatastoreImpl datastore, Properties properties, Interceptor interceptor) throws HibernateException {
        log.trace((Object)"Instantiating session factory");
        this.interceptor = interceptor;
        Dialect dl = null;
        boolean sl = false;
        try {
            dl = Dialect.getDialect(properties);
            sl = dl.supportsForUpdate();
            Properties temp = new Properties();
            temp.putAll((Map<?, ?>)dl.getDefaultProperties());
            temp.putAll((Map<?, ?>)properties);
            properties = temp;
        }
        catch (HibernateException he) {
            log.warn((Object)("No dialect set - using GenericDialect: " + he.getMessage()));
            dl = new GenericDialect();
        }
        this.dialect = dl;
        this.supportsLocking = sl;
        this.connections = ConnectionProviderFactory.newConnectionProvider(properties);
        int cacheSize = PropertiesHelper.getInt("hibernate.statement_cache.size", properties, 0);
        this.stCache = cacheSize < 1 || this.connections.isStatementCache() ? null : new PreparedStatementCache(cacheSize);
        this.statementFetchSize = PropertiesHelper.getInteger("hibernate.jdbc.fetch_size", properties);
        if (this.statementFetchSize != null) {
            log.info((Object)("JDBC result set fetch size: " + this.statementFetchSize));
        }
        this.useOuterJoin = PropertiesHelper.getBoolean("hibernate.use_outer_join", properties);
        log.info((Object)("Use outer join fetching: " + this.useOuterJoin));
        boolean usrs = PropertiesHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", properties);
        int batchSize = PropertiesHelper.getInt("hibernate.jdbc.batch_size", properties, 0);
        try {
            Connection conn = this.connections.getConnection();
            try {
                DatabaseMetaData meta = conn.getMetaData();
                boolean bl = usrs = usrs || meta.supportsResultSetType(1004);
                if (batchSize > 0 && !meta.supportsBatchUpdates()) {
                    batchSize = 0;
                }
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.connections.closeConnection(conn);
                throw throwable;
            }
            this.connections.closeConnection(conn);
            {
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)"Could not obtain connection metadata", (Throwable)sqle);
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        this.useScrollableResultSets = usrs;
        this.jdbcBatchSize = batchSize;
        log.info((Object)("Use scrollable result sets: " + this.useScrollableResultSets));
        if (batchSize > 0) {
            log.info((Object)("JDBC 2 max batch size: " + batchSize));
        }
        this.defaultSchema = properties.getProperty("hibernate.default_schema");
        if (this.defaultSchema != null) {
            log.info((Object)("Default schema set to: " + this.defaultSchema));
        }
        this.transactionFactory = this.buildTransactionFactory(properties);
        this.showSql = PropertiesHelper.getBoolean("hibernate.show_sql", properties);
        if (this.showSql) {
            log.info((Object)"echoing all SQL to stdout");
        }
        this.properties = properties;
        this.classPersisters = new HashMap();
        this.classPersistersByName = new HashMap();
        Iterator iter = datastore.getClassMaps();
        while (iter.hasNext()) {
            PersistentClass model = (PersistentClass)iter.next();
            Class persisterClass = model.getPersister();
            ClassPersister cp = persisterClass == null || persisterClass == (class$cirrus$hibernate$persister$EntityPersister == null ? SessionFactoryImpl.class$("cirrus.hibernate.persister.EntityPersister") : class$cirrus$hibernate$persister$EntityPersister) ? new EntityPersister(model, this) : (persisterClass == (class$cirrus$hibernate$persister$MultiTableEntityPersister == null ? SessionFactoryImpl.class$("cirrus.hibernate.persister.MultiTableEntityPersister") : class$cirrus$hibernate$persister$MultiTableEntityPersister) ? new MultiTableEntityPersister(model, this) : this.instantiatePersister(persisterClass, model));
            this.classPersisters.put(model.getPersistentClass(), cp);
            this.classPersistersByName.put(model.getName(), cp);
        }
        this.collectionPersisters = new HashMap();
        iter = datastore.getCollectionMaps();
        while (iter.hasNext()) {
            cirrus.hibernate.map.Collection map = (cirrus.hibernate.map.Collection)iter.next();
            this.collectionPersisters.put(map.getRole(), new CollectionPersister(map, datastore, this.defaultSchema, this));
        }
        iter = this.classPersisters.values().iterator();
        while (iter.hasNext()) {
            ((ClassPersister)iter.next()).postInstantiate(this);
        }
        String xsltInputFile = properties.getProperty("hibernate.xml.output_stylesheet");
        Templates tmpl = null;
        try {
            InputStream stream;
            if (xsltInputFile != null) {
                stream = this.getClass().getResourceAsStream(xsltInputFile);
                if (stream == null) {
                    stream = new FileInputStream(xsltInputFile);
                }
            } else {
                stream = this.getClass().getClassLoader().getResourceAsStream("cirrus/hibernate/hibernate-default.xslt");
            }
            tmpl = TransformerFactory.newInstance().newTemplates(new StreamSource(stream));
        }
        catch (Exception e) {
            log.warn((Object)"Problem opening output stylesheet - databinding disabled", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError tfce) {
            log.warn((Object)"no XSLT implementation found - databinding disabled");
        }
        this.templates = tmpl;
        this.name = properties.getProperty("hibernate.session_factory_name");
        try {
            this.uuid = (String)((Object)uuidgen.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, properties);
        this.querySubstitutions = PropertiesHelper.toMap("hibernate.query.substitutions", " ,=;:", properties);
        log.info((Object)("Query language substitutions: " + this.querySubstitutions));
        this.queryImports = PropertiesHelper.toStringArray("hibernate.query.imports", " ,;:", properties);
        if (this.queryImports.length != 0) {
            log.info((Object)("Query language imports: " + StringHelper.toString(this.queryImports)));
        }
        this.namedQueries = datastore.getNamedQueries();
        log.debug((Object)"Instantiated session factory");
    }

    public QueryTranslator getQuery(String query) throws QueryException, MappingException {
        return this.getQuery(query, false);
    }

    public QueryTranslator getScalarQuery(String query) throws QueryException, MappingException {
        return this.getQuery(query, true);
    }

    private QueryTranslator getQuery(String query, boolean scalar) throws QueryException, MappingException {
        String cacheKey = (scalar ? (char)'$' : '%') + query;
        QueryTranslator q = (QueryTranslator)this.queryCache.get((Object)cacheKey);
        if (q == null) {
            q = new QueryTranslator();
            this.queryCache.put((Object)cacheKey, (Object)q);
        }
        q.compile(this, query, this.querySubstitutions, scalar);
        return q;
    }

    public FilterTranslator getFilter(String query, String collectionRole, boolean scalar) throws QueryException, MappingException {
        String cacheKey = (scalar ? (char)'#' : '*') + query;
        FilterTranslator q = (FilterTranslator)this.queryCache.get((Object)cacheKey);
        if (q == null) {
            q = new FilterTranslator();
            this.queryCache.put((Object)cacheKey, (Object)q);
        }
        q.compile(collectionRole, this, query, this.querySubstitutions, scalar);
        return q;
    }

    private Session openSession(Connection connection, boolean autoClose, long timestamp, Interceptor interceptor) {
        return new SessionImpl(connection, this, autoClose, timestamp, interceptor);
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.openSession(connection, false, Long.MIN_VALUE, interceptor);
    }

    public Session openSession(Interceptor interceptor) throws SQLException {
        long timestamp = Timestamper.next();
        return this.openSession(null, true, timestamp, interceptor);
    }

    public Session openSession(Connection connection) {
        return this.openSession(connection, this.interceptor);
    }

    public Session openSession() throws SQLException {
        return this.openSession(this.interceptor);
    }

    public Connection openConnection() throws SQLException {
        return this.connections.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        JDBCExceptionReporter.logWarnings(conn.getWarnings());
        conn.clearWarnings();
        this.connections.closeConnection(conn);
    }

    public ClassPersister getPersister(String className) throws MappingException {
        ClassPersister result = (ClassPersister)this.classPersistersByName.get(className);
        if (result == null) {
            throw new MappingException("No persister for: " + className);
        }
        return result;
    }

    public ClassPersister getPersister(Class theClass) throws MappingException {
        ClassPersister result = (ClassPersister)this.classPersisters.get(theClass);
        if (result == null) {
            throw new MappingException("No persister for: " + theClass.getName());
        }
        return result;
    }

    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        CollectionPersister result = (CollectionPersister)this.collectionPersisters.get(role);
        if (result == null) {
            throw new MappingException("No persister for collection role: " + role);
        }
        return result;
    }

    public Databinder openDatabinder() throws HibernateException {
        if (this.templates == null) {
            throw new HibernateException("No output stylesheet configured. Use the property hibernate.output_stylesheet and ensure xalan.jar is in classpath");
        }
        try {
            return new XMLDatabinder(this, this.templates.newTransformer());
        }
        catch (Exception e) {
            log.error((Object)"Could not open Databinder", (Throwable)e);
            throw new HibernateException("Could not open Databinder", e);
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    private TransactionFactory buildTransactionFactory(Properties transactionProps) throws HibernateException {
        TransactionFactory factory;
        String strategyClassName = transactionProps.getProperty("hibernate.transaction.factory_class");
        if (strategyClassName == null) {
            return new JDBCTransactionFactory();
        }
        log.info((Object)("Transaction strategy: " + strategyClassName));
        try {
            factory = (TransactionFactory)ReflectHelper.classForName(strategyClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"TransactionFactory class not found", (Throwable)e);
            throw new HibernateException("TransactionFactory class not found: " + strategyClassName);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instantiate TransactionFactory", (Throwable)e);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instantiate TransactionFactory", (Throwable)e);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + e);
        }
        factory.configure(transactionProps);
        return factory;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public Reference getReference() throws NamingException {
        log.debug((Object)"Returning a Reference to the SessionFactory");
        return new Reference((class$cirrus$hibernate$impl$SessionFactoryImpl == null ? (class$cirrus$hibernate$impl$SessionFactoryImpl = SessionFactoryImpl.class$("cirrus.hibernate.impl.SessionFactoryImpl")) : class$cirrus$hibernate$impl$SessionFactoryImpl).getName(), new StringRefAddr("uuid", this.uuid), (class$cirrus$hibernate$impl$SessionFactoryObjectFactory == null ? (class$cirrus$hibernate$impl$SessionFactoryObjectFactory = SessionFactoryImpl.class$("cirrus.hibernate.impl.SessionFactoryObjectFactory")) : class$cirrus$hibernate$impl$SessionFactoryObjectFactory).getName(), null);
    }

    Object readResolve() throws ObjectStreamException {
        log.trace((Object)"Resolving serialized SessionFactory");
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a SessionFactory named: " + this.name);
            }
            log.debug((Object)"resolved SessionFactory by name");
        } else {
            log.debug((Object)"resolved SessionFactory by uid");
        }
        return result;
    }

    public PreparedStatement getPreparedStatement(Connection conn, String sql, boolean scrollable) throws SQLException {
        if (scrollable && !this.useScrollableResultSets) {
            throw new AssertionFailure("Hibernate tried to grab a scrollable result set when it knew there were none");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)((scrollable ? "scrollable " : "") + "prepared statement get: " + sql));
        }
        if (this.showSql) {
            System.out.println("Hibernate: " + sql);
        }
        if (this.stCache != null) {
            return this.stCache.getPreparedStatement(sql, conn, scrollable);
        }
        try {
            log.trace((Object)"preparing statement");
            return scrollable ? conn.prepareStatement(sql, 1004, 1007) : conn.prepareStatement(sql);
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public void closePreparedStatement(PreparedStatement ps) throws SQLException {
        if (this.stCache != null) {
            this.stCache.closePreparedStatement(ps);
        } else {
            try {
                log.trace((Object)"closing statement");
                ps.close();
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
        }
    }

    public boolean useJdbcBatch() {
        return this.jdbcBatchSize > 0;
    }

    public int getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    public boolean useScrollableResultSets() {
        return this.useScrollableResultSets;
    }

    public boolean enableJoinedFetch() {
        return this.useOuterJoin;
    }

    public String getNamedQuery(String name) throws MappingException {
        String queryString = (String)this.namedQueries.get(name);
        if (queryString == null) {
            throw new MappingException("Named query not known: " + name);
        }
        return queryString;
    }

    public Type getIdentifierType(Class ObjectClass) throws MappingException {
        return this.getPersister(ObjectClass).getIdentifierType();
    }

    public Type getCollectionKeyType(String role) throws MappingException {
        return this.getCollectionPersister(role).getKeyType();
    }

    private final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        log.trace((Object)"deserializing");
        in.defaultReadObject();
        log.debug((Object)("deserialized: " + this.uuid));
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        log.debug((Object)("serializing: " + this.uuid));
        out.defaultWriteObject();
        log.trace((Object)"serialized");
    }

    public Type[] getReturnTypes(String queryString) throws HibernateException {
        String[] queries = QueryTranslator.concreteQueries(queryString, this);
        if (queries.length == 0) {
            throw new HibernateException("Query does not refer to any persistent classes: " + queryString);
        }
        return this.getScalarQuery(queries[0]).getReturnTypes();
    }

    public Collection getNamedParameters(String queryString) throws HibernateException {
        String[] queries = QueryTranslator.concreteQueries(queryString, this);
        if (queries.length == 0) {
            throw new HibernateException("Query does not refer to any persistent classes: " + queryString);
        }
        return this.getScalarQuery(queries[0]).getNamedParameters();
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setFetchSize(PreparedStatement statement) throws SQLException {
        if (this.statementFetchSize != null) {
            statement.setFetchSize(this.statementFetchSize);
        }
    }

    private ClassPersister instantiatePersister(Class persisterClass, PersistentClass model) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
        try {
            return (ClassPersister)pc.newInstance(model, this);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof HibernateException) {
                throw (HibernateException)((Object)e);
            }
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getPersister(persistentClass).getClassMetadata();
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.getCollectionPersister(roleName);
    }

    public String[] getImplementors(Class clazz) {
        ArrayList<String> results = new ArrayList<String>();
        Iterator iter = this.classPersisters.values().iterator();
        while (iter.hasNext()) {
            ClassPersister p = (ClassPersister)iter.next();
            if (!(p instanceof Queryable)) continue;
            Queryable q = (Queryable)p;
            String name = q.getClassName();
            boolean isMappedClass = clazz.equals(q.getMappedClass());
            if (q.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{name};
            }
            if (isMappedClass) {
                results.add(name);
                continue;
            }
            if (!clazz.isAssignableFrom(q.getMappedClass()) || q.isInherited() && clazz.isAssignableFrom(q.getMappedSuperclass())) continue;
            results.add(name);
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getImports() {
        return this.queryImports;
    }

    public Map getAllClassMetadata() throws HibernateException {
        return Collections.unmodifiableMap(this.classPersisters);
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return Collections.unmodifiableMap(this.collectionPersisters);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

