/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.connection;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.connection.ConnectionProvider;
import cirrus.hibernate.helpers.JDBCExceptionReporter;
import cirrus.hibernate.helpers.NamingHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasourceConnectionProvider
implements ConnectionProvider {
    private DataSource ds;
    private String user;
    private String pass;
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$connection$DatasourceConnectionProvider == null ? (class$cirrus$hibernate$connection$DatasourceConnectionProvider = DatasourceConnectionProvider.class$("cirrus.hibernate.connection.DatasourceConnectionProvider")) : class$cirrus$hibernate$connection$DatasourceConnectionProvider));
    static /* synthetic */ Class class$cirrus$hibernate$connection$DatasourceConnectionProvider;

    public void configure(Properties props) throws HibernateException {
        String jndi_name = props.getProperty("hibernate.connection.datasource");
        if (jndi_name == null) {
            String msg = "datasource JNDI name was not specified by property hibernate.connection.datasource";
            log.fatal((Object)msg);
            throw new HibernateException(msg);
        }
        this.user = props.getProperty("hibernate.connection.username");
        this.pass = props.getProperty("hibernate.connection.password");
        try {
            this.ds = (DataSource)NamingHelper.getInitialContext(props).lookup(jndi_name);
        }
        catch (Exception e) {
            log.fatal((Object)("Could not find datasource: " + jndi_name), (Throwable)e);
            throw new HibernateException("Could not find datasource", e);
        }
        log.info((Object)("Using datasource: " + jndi_name));
    }

    public Connection getConnection() throws SQLException {
        try {
            if (this.user != null || this.pass != null) {
                return this.ds.getConnection(this.user, this.pass);
            }
            return this.ds.getConnection();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public void closeConnection(Connection conn) throws SQLException {
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public boolean isStatementCache() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

