/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.streaming;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.streaming.XMLReaderException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.WebServiceException;

public abstract class XMLStreamWriterFactory {
    @NotNull
    private static volatile XMLStreamWriterFactory theInstance;

    public abstract XMLStreamWriter doCreate(OutputStream var1);

    public abstract XMLStreamWriter doCreate(OutputStream var1, String var2);

    public abstract void doRecycle(XMLStreamWriter var1);

    public static void recycle(XMLStreamWriter r) {
        XMLStreamWriterFactory.get().doRecycle(r);
    }

    @NotNull
    public static XMLStreamWriterFactory get() {
        return theInstance;
    }

    public static void set(@NotNull XMLStreamWriterFactory f) {
        if (f == null) {
            throw new IllegalArgumentException();
        }
        theInstance = f;
    }

    public static XMLStreamWriter create(OutputStream out) {
        return XMLStreamWriterFactory.get().doCreate(out);
    }

    public static XMLStreamWriter create(OutputStream out, String encoding) {
        return XMLStreamWriterFactory.get().doCreate(out, encoding);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) {
        return XMLStreamWriterFactory.create(out);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) {
        return XMLStreamWriterFactory.create(out, encoding);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding, boolean declare) {
        return XMLStreamWriterFactory.create(out, encoding);
    }

    static {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriterFactory f = null;
        if (!Boolean.getBoolean(XMLStreamWriterFactory.class.getName() + ".noPool")) {
            f = Zephyr.newInstance(xof);
        }
        if (f == null) {
            f = new Default(xof);
        }
        theInstance = f;
    }

    public static final class Zephyr
    extends XMLStreamWriterFactory {
        private final XMLOutputFactory xof;
        private final ThreadLocal<XMLStreamWriter> pool = new ThreadLocal();
        private final Method resetMethod;
        private final Method setOutputMethod;
        private final Class zephyrClass;

        public static XMLStreamWriterFactory newInstance(XMLOutputFactory xof) {
            try {
                Class<?> clazz = xof.createXMLStreamWriter(new StringWriter()).getClass();
                if (!clazz.getName().startsWith("com.sun.xml.stream.")) {
                    return null;
                }
                return new Zephyr(xof, clazz);
            }
            catch (XMLStreamException e) {
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        private Zephyr(XMLOutputFactory xof, Class clazz) throws NoSuchMethodException {
            this.xof = xof;
            this.zephyrClass = clazz;
            this.setOutputMethod = clazz.getMethod("setOutput", StreamResult.class, String.class);
            this.resetMethod = clazz.getMethod("reset", new Class[0]);
        }

        @Nullable
        private XMLStreamWriter fetch() {
            XMLStreamWriter sr = this.pool.get();
            if (sr == null) {
                return null;
            }
            this.pool.set(null);
            return sr;
        }

        public XMLStreamWriter doCreate(OutputStream out) {
            return this.doCreate(out, "UTF-8");
        }

        public XMLStreamWriter doCreate(OutputStream out, String encoding) {
            XMLStreamWriter xsw = this.fetch();
            if (xsw != null) {
                try {
                    this.resetMethod.invoke((Object)xsw, new Object[0]);
                    this.setOutputMethod.invoke((Object)xsw, new StreamResult(out), encoding);
                    return xsw;
                }
                catch (IllegalAccessException e) {
                    throw new XMLReaderException("stax.cantCreate", new Object[]{e});
                }
                catch (InvocationTargetException e) {
                    throw new XMLReaderException("stax.cantCreate", new Object[]{e});
                }
            }
            try {
                return this.xof.createXMLStreamWriter(out, encoding);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
        }

        public void doRecycle(XMLStreamWriter r) {
            if (this.zephyrClass.isInstance(r)) {
                try {
                    r.close();
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException(e);
                }
                this.pool.set(r);
            }
            if (r instanceof RecycleAware) {
                ((RecycleAware)((Object)r)).onRecycled();
            }
        }
    }

    public static final class Default
    extends XMLStreamWriterFactory {
        private final XMLOutputFactory xof;

        public Default(XMLOutputFactory xof) {
            this.xof = xof;
        }

        public XMLStreamWriter doCreate(OutputStream out) {
            return this.doCreate(out, "UTF-8");
        }

        public synchronized XMLStreamWriter doCreate(OutputStream out, String encoding) {
            try {
                return this.xof.createXMLStreamWriter(out, encoding);
            }
            catch (XMLStreamException e) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{e});
            }
        }

        public void doRecycle(XMLStreamWriter r) {
        }
    }

    public static interface RecycleAware {
        public void onRecycled();
    }
}

