/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Options;

class NodeFiles {
    NodeFiles() {
    }

    static String path() {
        String string = Options.S("OUTPUT_DIRECTORY");
        if (string.equals("")) {
            return "";
        }
        return string + System.getProperty("file.separator");
    }

    static void ensure(IO iO, String string) {
        String string2 = NodeFiles.path() + string + ".java";
        if (!string.equals("Node")) {
            if (string.equals("SimpleNode")) {
                NodeFiles.ensure(iO, "Node");
            } else {
                NodeFiles.ensure(iO, "SimpleNode");
            }
        }
        if (!string.equals("Node") && !Options.B("BUILD_NODE_FILES")) {
            return;
        }
        if (new File(string2).exists()) {
            return;
        }
        iO.getMsg().println("File \"" + string2 + "\" does not exist.  Will create one.");
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2), 8096));
            if (string.equals("Node")) {
                NodeFiles.generateNode_java(printWriter);
            } else if (string.equals("SimpleNode")) {
                NodeFiles.generateSimpleNode_java(printWriter);
            } else {
                NodeFiles.generateMULTINode_java(printWriter, string);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    static void generatePrologue(PrintWriter printWriter, String string) {
        printWriter.println("/* " + JavaCCGlobals.getIdString(JJTreeGlobals.toolList, string) + " */");
        printWriter.println();
        if (!JJTreeGlobals.packageName.equals("")) {
            printWriter.println("package " + JJTreeGlobals.packageName + ";");
            printWriter.println();
        }
    }

    static String nodeConstants() {
        return JJTreeGlobals.parserName + "TreeConstants";
    }

    static void generateTreeConstants_java() {
        String string = NodeFiles.nodeConstants();
        String string2 = NodeFiles.path() + string + ".java";
        try {
            String string3;
            int n;
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2), 8096));
            Vector vector = ASTNodeDescriptor.getNodeIds();
            Vector vector2 = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(printWriter, string2);
            printWriter.println("public interface " + string);
            printWriter.println("{");
            for (n = 0; n < vector.size(); ++n) {
                string3 = (String)vector.elementAt(n);
                printWriter.println("  public int " + string3 + " = " + n + ";");
            }
            printWriter.println();
            printWriter.println();
            printWriter.println("  public String[] jjtNodeName = {");
            for (n = 0; n < vector2.size(); ++n) {
                string3 = (String)vector2.elementAt(n);
                printWriter.println("    \"" + string3 + "\",");
            }
            printWriter.println("  };");
            printWriter.println("}");
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    static String visitorClass() {
        return JJTreeGlobals.parserName + "Visitor";
    }

    static void generateVisitor_java() {
        if (!Options.B("VISITOR")) {
            return;
        }
        String string = NodeFiles.visitorClass();
        String string2 = NodeFiles.path() + string + ".java";
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2), 8096));
            Vector vector = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(printWriter, string2);
            printWriter.println("public interface " + string);
            printWriter.println("{");
            String string3 = Options.S("VISITOR_EXCEPTION");
            if (!string3.equals("")) {
                string3 = " throws " + string3;
            }
            printWriter.println("  public Object visit(SimpleNode node, Object data)" + string3 + ";");
            if (Options.B("MULTI")) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string4 = (String)vector.elementAt(i);
                    if (string4.equals("void")) continue;
                    String string5 = Options.S("NODE_PREFIX") + string4;
                    printWriter.println("  public Object visit(" + string5 + " node, Object data)" + string3 + ";");
                }
            }
            printWriter.println("}");
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    private static void generateNode_java(PrintWriter printWriter) {
        NodeFiles.generatePrologue(printWriter, "Node.java");
        printWriter.println("/* All AST nodes must implement this interface.  It provides basic");
        printWriter.println("   machinery for constructing the parent and child relationships");
        printWriter.println("   between nodes. */");
        printWriter.println("");
        printWriter.println("public interface Node {");
        printWriter.println("");
        printWriter.println("  /** This method is called after the node has been made the current");
        printWriter.println("    node.  It indicates that child nodes can now be added to it. */");
        printWriter.println("  public void jjtOpen();");
        printWriter.println("");
        printWriter.println("  /** This method is called after all the child nodes have been");
        printWriter.println("    added. */");
        printWriter.println("  public void jjtClose();");
        printWriter.println("");
        printWriter.println("  /** This pair of methods are used to inform the node of its");
        printWriter.println("    parent. */");
        printWriter.println("  public void jjtSetParent(Node n);");
        printWriter.println("  public Node jjtGetParent();");
        printWriter.println("");
        printWriter.println("  /** This method tells the node to add its argument to the node's");
        printWriter.println("    list of children.  */");
        printWriter.println("  public void jjtAddChild(Node n, int i);");
        printWriter.println("");
        printWriter.println("  /** This method returns a child node.  The children are numbered");
        printWriter.println("     from zero, left to right. */");
        printWriter.println("  public Node jjtGetChild(int i);");
        printWriter.println("");
        printWriter.println("  /** Return the number of children the node has. */");
        printWriter.println("  public int jjtGetNumChildren();");
        if (Options.B("VISITOR")) {
            String string = Options.S("VISITOR_EXCEPTION");
            if (!string.equals("")) {
                string = " throws " + string;
            }
            printWriter.println("");
            printWriter.println("  /** Accept the visitor. **/");
            printWriter.println("  public Object jjtAccept(" + NodeFiles.visitorClass() + " visitor, Object data)" + string + ";");
        }
        printWriter.println("}");
        printWriter.close();
    }

    private static void generateSimpleNode_java(PrintWriter printWriter) {
        NodeFiles.generatePrologue(printWriter, "SimpleNode.java");
        printWriter.println("public class SimpleNode implements Node {");
        printWriter.println("  protected Node parent;");
        printWriter.println("  protected Node[] children;");
        printWriter.println("  protected int id;");
        printWriter.println("  protected " + JJTreeGlobals.parserName + " parser;");
        printWriter.println("");
        printWriter.println("  public SimpleNode(int i) {");
        printWriter.println("    id = i;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public SimpleNode(" + JJTreeGlobals.parserName + " p, int i) {");
        printWriter.println("    this(i);");
        printWriter.println("    parser = p;");
        printWriter.println("  }");
        printWriter.println("");
        if (Options.B("NODE_FACTORY")) {
            printWriter.println("  public static Node jjtCreate(int id) {");
            printWriter.println("    return new SimpleNode(id);");
            printWriter.println("  }");
            printWriter.println("");
            printWriter.println("  public static Node jjtCreate(" + JJTreeGlobals.parserName + " p, int id) {");
            printWriter.println("    return new SimpleNode(p, id);");
            printWriter.println("  }");
            printWriter.println("");
        }
        printWriter.println("  public void jjtOpen() {");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public void jjtClose() {");
        printWriter.println("  }");
        printWriter.println("  ");
        printWriter.println("  public void jjtSetParent(Node n) { parent = n; }");
        printWriter.println("  public Node jjtGetParent() { return parent; }");
        printWriter.println("");
        printWriter.println("  public void jjtAddChild(Node n, int i) {");
        printWriter.println("    if (children == null) {");
        printWriter.println("      children = new Node[i + 1];");
        printWriter.println("    } else if (i >= children.length) {");
        printWriter.println("      Node c[] = new Node[i + 1];");
        printWriter.println("      System.arraycopy(children, 0, c, 0, children.length);");
        printWriter.println("      children = c;");
        printWriter.println("    }");
        printWriter.println("    children[i] = n;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public Node jjtGetChild(int i) {");
        printWriter.println("    return children[i];");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  public int jjtGetNumChildren() {");
        printWriter.println("    return (children == null) ? 0 : children.length;");
        printWriter.println("  }");
        printWriter.println("");
        if (Options.B("VISITOR")) {
            String string = Options.S("VISITOR_EXCEPTION");
            if (!string.equals("")) {
                string = " throws " + string;
            }
            printWriter.println("  /** Accept the visitor. **/");
            printWriter.println("  public Object jjtAccept(" + NodeFiles.visitorClass() + " visitor, Object data)" + string + " {");
            printWriter.println("    return visitor.visit(this, data);");
            printWriter.println("  }");
            printWriter.println("");
            printWriter.println("  /** Accept the visitor. **/");
            printWriter.println("  public Object childrenAccept(" + NodeFiles.visitorClass() + " visitor, Object data)" + string + " {");
            printWriter.println("    if (children != null) {");
            printWriter.println("      for (int i = 0; i < children.length; ++i) {");
            printWriter.println("        children[i].jjtAccept(visitor, data);");
            printWriter.println("      }");
            printWriter.println("    }");
            printWriter.println("    return data;");
            printWriter.println("  }");
            printWriter.println("");
        }
        printWriter.println("  /* You can override these two methods in subclasses of SimpleNode to");
        printWriter.println("     customize the way the node appears when the tree is dumped.  If");
        printWriter.println("     your output uses more than one line you should override");
        printWriter.println("     toString(String), otherwise overriding toString() is probably all");
        printWriter.println("     you need to do. */");
        printWriter.println("");
        printWriter.println("  public String toString() { return " + NodeFiles.nodeConstants() + ".jjtNodeName[id]; }");
        printWriter.println("  public String toString(String prefix) { return prefix + toString(); }");
        printWriter.println("");
        printWriter.println("  /* Override this method if you want to customize how the node dumps");
        printWriter.println("     out its children. */");
        printWriter.println("");
        printWriter.println("  public void dump(String prefix) {");
        printWriter.println("    System.out.println(toString(prefix));");
        printWriter.println("    if (children != null) {");
        printWriter.println("      for (int i = 0; i < children.length; ++i) {");
        printWriter.println("\tSimpleNode n = (SimpleNode)children[i];");
        printWriter.println("\tif (n != null) {");
        printWriter.println("\t  n.dump(prefix + \" \");");
        printWriter.println("\t}");
        printWriter.println("      }");
        printWriter.println("    }");
        printWriter.println("  }");
        printWriter.println("}");
        printWriter.println("");
    }

    private static void generateMULTINode_java(PrintWriter printWriter, String string) {
        NodeFiles.generatePrologue(printWriter, string + ".java");
        printWriter.println("public class " + string + " extends SimpleNode {");
        printWriter.println("  public " + string + "(int id) {");
        printWriter.println("    super(id);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public " + string + "(" + JJTreeGlobals.parserName + " p, int id) {");
        printWriter.println("    super(p, id);");
        printWriter.println("  }");
        printWriter.println();
        if (Options.B("NODE_FACTORY")) {
            printWriter.println("  public static Node jjtCreate(int id) {");
            printWriter.println("      return new " + string + "(id);");
            printWriter.println("  }");
            printWriter.println();
            printWriter.println("  public static Node jjtCreate(" + JJTreeGlobals.parserName + " p, int id) {");
            printWriter.println("      return new " + string + "(p, id);");
            printWriter.println("  }");
        }
        if (Options.B("VISITOR")) {
            String string2 = Options.S("VISITOR_EXCEPTION");
            if (!string2.equals("")) {
                string2 = " throws " + string2;
            }
            printWriter.println("");
            printWriter.println("  /** Accept the visitor. **/");
            printWriter.println("  public Object jjtAccept(" + NodeFiles.visitorClass() + " visitor, Object data)" + string2 + " {");
            printWriter.println("    return visitor.visit(this, data);");
            printWriter.println("  }");
        }
        printWriter.println("}");
        printWriter.close();
    }
}

