/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import java.util.Random;

public class NoiseFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 1970783813893879484L;
    private int amount = 25;
    private boolean gaussian = false;
    private boolean monochrome = false;
    private Random randomNumbers = new Random();

    public void setAmount(int n) {
        this.amount = n;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setGaussian(boolean bl) {
        this.gaussian = bl;
    }

    public boolean getGaussian() {
        return this.gaussian;
    }

    public void setMonochrome(boolean bl) {
        this.monochrome = bl;
    }

    public boolean getMonochrome() {
        return this.monochrome;
    }

    private int random(int n) {
        if ((n += (int)((this.gaussian ? this.randomNumbers.nextGaussian() : 2.0 * this.randomNumbers.nextDouble() - 1.0) * (double)this.amount)) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 & 0xFF000000;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        if (this.monochrome) {
            int n8 = (int)((this.gaussian ? this.randomNumbers.nextGaussian() : 2.0 * this.randomNumbers.nextDouble() - 1.0) * (double)this.amount);
            n5 = PixelUtils.clamp(n5 + n8);
            n6 = PixelUtils.clamp(n6 + n8);
            n7 = PixelUtils.clamp(n7 + n8);
        } else {
            n5 = this.random(n5);
            n6 = this.random(n6);
            n7 = this.random(n7);
        }
        return n4 | n5 << 16 | n6 << 8 | n7;
    }

    public String toString() {
        return "Stylize/Add Noise...";
    }
}

