/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import java.io.IOException;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Handler;
import org.apache.tools.ant.taskdefs.optional.perforce.SimpleP4OutputHandler;
import org.apache.tools.ant.types.Commandline;

public abstract class P4Base
extends Task {
    protected Perl5Util util = null;
    protected String shell;
    protected String P4Port = "";
    protected String P4Client = "";
    protected String P4User = "";
    protected String P4View = "";
    protected boolean failOnError = true;
    protected String P4Opts = "";
    protected String P4CmdOpts = "";

    public void setPort(String P4Port) {
        this.P4Port = "-p" + P4Port;
    }

    public void setClient(String P4Client) {
        this.P4Client = "-c" + P4Client;
    }

    public void setUser(String P4User) {
        this.P4User = "-u" + P4User;
    }

    public void setView(String P4View) {
        this.P4View = P4View;
    }

    public void setCmdopts(String P4CmdOpts) {
        this.P4CmdOpts = P4CmdOpts;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void init() {
        this.util = new Perl5Util();
        String tmpprop = this.project.getProperty("p4.port");
        if (tmpprop != null) {
            this.setPort(tmpprop);
        }
        if ((tmpprop = this.project.getProperty("p4.client")) != null) {
            this.setClient(tmpprop);
        }
        if ((tmpprop = this.project.getProperty("p4.user")) != null) {
            this.setUser(tmpprop);
        }
    }

    protected void execP4Command(String command) throws BuildException {
        this.execP4Command(command, null);
    }

    /*
     * Loose catch block
     */
    protected void execP4Command(String command, P4Handler handler) throws BuildException {
        block15: {
            try {
                Commandline commandline = new Commandline();
                commandline.setExecutable("p4");
                if (this.P4Port != null && this.P4Port.length() != 0) {
                    commandline.createArgument().setValue(this.P4Port);
                }
                if (this.P4User != null && this.P4User.length() != 0) {
                    commandline.createArgument().setValue(this.P4User);
                }
                if (this.P4Client != null && this.P4Client.length() != 0) {
                    commandline.createArgument().setValue(this.P4Client);
                }
                commandline.createArgument().setLine(command);
                String[] cmdline = commandline.getCommandline();
                String cmdl = "";
                int i = 0;
                while (i < cmdline.length) {
                    cmdl = cmdl + cmdline[i] + " ";
                    ++i;
                }
                this.log(commandline.describeCommand(), 3);
                if (handler == null) {
                    handler = new SimpleP4OutputHandler(this);
                }
                Execute exe = new Execute((ExecuteStreamHandler)handler, null);
                exe.setAntRun(this.project);
                exe.setCommandline(commandline.getCommandline());
                exe.execute();
                Object var10_10 = null;
                try {
                    handler.stop();
                }
                catch (Exception e) {}
                break block15;
                {
                    catch (IOException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    try {
                        handler.stop();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                String failMsg = "Problem exec'ing P4 command: " + e.getMessage();
                if (this.failOnError) {
                    throw new BuildException(failMsg);
                }
                this.log(failMsg, 0);
            }
        }
    }
}

