/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.optional.ejb.EjbJar;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class JonasDeploymentTool
extends GenericDeploymentTool {
    protected static final String JONAS_DD = "jonas-ejb-jar.xml";
    protected static final String GENIC_CLASS = "org.objectweb.jonas_ejb.tools.GenWholeIC";
    protected static final String OLD_GENIC_CLASS = "org.objectweb.jonas_ejb.tools.GenIC";
    protected static final String DEFAULT_ORB = "RMI";
    private String jarSuffix = ".jar";
    private String genicClass;
    private String additionalArgs = "";
    private boolean keepgenerated = false;
    private boolean keepGeneric = false;
    private File jonasroot;
    private boolean secpropag = false;
    private File ouputdirectory;
    private String compiler;
    private boolean verbose;
    private String orb;
    private boolean cleanWorkDir = false;
    private boolean noGENIC = false;

    public void setGenicClass(String inGenicClass) {
        this.genicClass = inGenicClass;
    }

    public void setOrb(String inValue) {
        this.orb = inValue;
    }

    public void setCompiler(String inCompiler) {
        this.compiler = inCompiler;
    }

    public void setKeepgeneric(boolean inValue) {
        this.keepGeneric = inValue;
    }

    public void setVerbose(boolean inValue) {
        this.verbose = inValue;
    }

    public void setNoGENIC(boolean inValue) {
        this.noGENIC = inValue;
    }

    public void setKeepgenerated(boolean inValue) {
        this.keepgenerated = inValue;
    }

    public void setJonasroot(File inValue) {
        this.jonasroot = inValue;
    }

    public void setSecpropag(boolean inValue) {
        this.secpropag = inValue;
    }

    public void setOuputdir(File inValue) {
        this.ouputdirectory = inValue;
    }

    public void setWorkdir(File inValue) {
        this.setOuputdir(inValue);
    }

    public void setCleanworkdir(boolean inValue) {
        this.cleanWorkDir = inValue;
    }

    public void setSuffix(String inString) {
        this.jarSuffix = inString;
    }

    public void setArgs(String inArgs) {
        this.additionalArgs = inArgs;
    }

    protected void addVendorFiles(Hashtable someEjbFiles, String aDdPrefix) {
        File aJonasDD = new File(this.getConfig().descriptorDir, aDdPrefix + JONAS_DD);
        if (aJonasDD.exists()) {
            someEjbFiles.put("META-INF/jonas-ejb-jar.xml", aJonasDD);
        } else if (!this.addJonasVendorFiles(someEjbFiles, aDdPrefix)) {
            this.log("Unable to locate JOnAS deployment descriptor. It was expected to be in " + aJonasDD.getPath() + ". Alternatively, please use JOnAS naming convention.", 1);
        }
    }

    private boolean addJonasVendorFiles(Hashtable someEjbFiles, String aDdPrefix) {
        int index;
        String aCanonicalDD = aDdPrefix.replace('\\', '/').substring(0, aDdPrefix.length() - 1);
        String anEjbJarName = aCanonicalDD.substring(index = aCanonicalDD.lastIndexOf(47) + 1);
        if ("ejb".equals(anEjbJarName)) {
            anEjbJarName = "ejb-jar";
        }
        String aNewDdPrefix = aDdPrefix.substring(0, index) + "jonas-" + anEjbJarName + ".xml";
        File aConventionNamingJonasDD = new File(this.getConfig().descriptorDir, aNewDdPrefix);
        this.log("look for jonas specific file using jonas naming convention " + aConventionNamingJonasDD, 3);
        if (aConventionNamingJonasDD.exists()) {
            someEjbFiles.put("META-INF/jonas-ejb-jar.xml", aConventionNamingJonasDD);
            return true;
        }
        return false;
    }

    protected String getJarBaseName(String aDescriptorFileName) {
        String aCanonicalDescriptor;
        int lastSeparatorIndex;
        int endBaseName;
        String aBaseName = null;
        EjbJar.Config aConfig = super.getConfig();
        if (aConfig.namingScheme.getValue().equals("descriptor") && aDescriptorFileName.indexOf(aConfig.baseNameTerminator) == -1 && (endBaseName = (lastSeparatorIndex = (aCanonicalDescriptor = aDescriptorFileName.replace('\\', '/')).lastIndexOf(47)) != -1 ? aDescriptorFileName.indexOf(".xml", lastSeparatorIndex) : aDescriptorFileName.indexOf(".xml")) != -1) {
            aBaseName = aDescriptorFileName.substring(0, endBaseName);
        }
        if (aBaseName == null) {
            aBaseName = super.getJarBaseName(aDescriptorFileName);
        }
        return aBaseName;
    }

    protected void writeJar(String baseName, File jarFile, Hashtable files, String publicId) throws BuildException {
        File genericJarFile = super.getVendorOutputJarFile(baseName);
        super.writeJar(baseName, genericJarFile, files, publicId);
        this.buildJOnASJar(baseName, genericJarFile, jarFile, files, publicId);
        if (!this.keepGeneric) {
            this.log("deleting generic jar " + genericJarFile.toString(), 3);
            genericJarFile.delete();
        }
    }

    private void buildJOnASJar(String inBaseName, File inSourceJar, File inDestJar, Hashtable someFiles, String inPublicId) {
        Java aJavaTask = null;
        String aGenIcClassName = this.genicClass;
        boolean isOldGenIC = false;
        boolean isTempDirectory = false;
        File anOutputDirectoryFile = null;
        if (this.noGENIC) {
            try {
                FileUtils.newFileUtils().copyFile(inSourceJar, inDestJar);
                return;
            }
            catch (IOException anIOException) {
                throw new BuildException("Unable to write EJB jar", (Throwable)anIOException);
            }
        }
        try {
            try {
                aJavaTask = (Java)this.getTask().getProject().createTask("java");
                aJavaTask.setTaskName("genic");
                if (aGenIcClassName == null) {
                    aGenIcClassName = GENIC_CLASS;
                } else if (OLD_GENIC_CLASS.equals(aGenIcClassName)) {
                    isOldGenIC = true;
                }
                aJavaTask.setClassname(aGenIcClassName);
                if (this.jonasroot == null) {
                    throw new BuildException("Error : set the jonasroot parameter");
                }
                if (!this.jonasroot.isDirectory()) {
                    this.log("jonasroot attribut '" + this.jonasroot + "' is not a valid directory", 0);
                }
                aJavaTask.createJvmarg().setValue("-Dinstall.root=" + this.jonasroot);
                File aJavaPolicyFile = new File(this.jonasroot, "config/java.policy");
                if (aJavaPolicyFile.exists()) {
                    aJavaTask.createJvmarg().setValue("-Djava.security.policy=" + aJavaPolicyFile.toString());
                }
                if (this.ouputdirectory == null) {
                    anOutputDirectoryFile = this.createTempDir();
                    isTempDirectory = true;
                    this.log("Use temporary output directory : " + anOutputDirectoryFile, 3);
                } else {
                    anOutputDirectoryFile = this.ouputdirectory;
                    this.log("Use temporary specific output directory : " + anOutputDirectoryFile, 3);
                }
                aJavaTask.createArg().setValue("-d");
                aJavaTask.createArg().setFile(anOutputDirectoryFile);
                aJavaTask.createArg().setLine(this.additionalArgs);
                if (this.keepgenerated) {
                    aJavaTask.createArg().setValue("-keepgenerated");
                }
                if (this.verbose) {
                    aJavaTask.createArg().setValue("-verbose");
                }
                if (this.secpropag) {
                    aJavaTask.createArg().setValue("-secpropag");
                }
                if (this.compiler == null) {
                    String aBuildCompiler = this.getTask().getProject().getProperty("build.compiler");
                    if ("jikes".equals(aBuildCompiler)) {
                        aJavaTask.createArg().setValue("-javac");
                        aJavaTask.createArg().setValue("jikes");
                    }
                } else if (!"default".equals(this.compiler)) {
                    aJavaTask.createArg().setValue("-javac");
                    aJavaTask.createArg().setLine(this.compiler);
                }
                if (!isOldGenIC) {
                    aJavaTask.createArg().setValue("-noaddinjar");
                }
                aJavaTask.createArg().setValue(inSourceJar.getPath());
                Path aClasspath = this.getCombinedClasspath();
                if (aClasspath == null) {
                    aClasspath = new Path(this.getTask().getProject());
                }
                if (this.orb != null) {
                    String aOrbJar = new File(this.jonasroot, "lib/" + this.orb + "_jonas.jar").toString();
                    String aConfigDir = new File(this.jonasroot, "config/").toString();
                    Path aJOnASOrbPath = new Path(aClasspath.getProject(), aOrbJar + File.pathSeparator + aConfigDir);
                    aClasspath.append(aJOnASOrbPath);
                } else {
                    this.log("No ORB propertie setup (RMI, JEREMIE, DAVID).", 1);
                }
                aClasspath.append(new Path(aClasspath.getProject(), anOutputDirectoryFile.getPath()));
                aJavaTask.setClasspath(aClasspath);
                aJavaTask.setFork(true);
                this.log("Calling " + aGenIcClassName + " for " + inSourceJar.toString(), 3);
                if (aJavaTask.executeJava() != 0) {
                    throw new BuildException("GenIC reported an error");
                }
                this.addAllFiles(anOutputDirectoryFile, "", someFiles);
                super.writeJar(inBaseName, inDestJar, someFiles, inPublicId);
            }
            catch (BuildException aBuildException) {
                throw aBuildException;
            }
            catch (Exception e) {
                String msg = "Exception while calling " + aGenIcClassName + ". Details: " + e.toString();
                throw new BuildException(msg, (Throwable)e);
            }
            Object var17_20 = null;
            if (isTempDirectory && anOutputDirectoryFile != null) {
                this.dellAllFiles(anOutputDirectoryFile);
            } else if (this.cleanWorkDir && anOutputDirectoryFile != null) {
                this.dellAllFilesInside(anOutputDirectoryFile);
            }
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            if (isTempDirectory && anOutputDirectoryFile != null) {
                this.dellAllFiles(anOutputDirectoryFile);
            } else if (this.cleanWorkDir && anOutputDirectoryFile != null) {
                this.dellAllFilesInside(anOutputDirectoryFile);
            }
            throw throwable;
        }
    }

    File getVendorOutputJarFile(String aBaseName) {
        return new File(this.getDestDir(), aBaseName + this.jarSuffix);
    }

    private File createTempDir() {
        String theTempDir = System.getProperty("java.io.tmpdir");
        int anIndice = 0;
        File aFile = null;
        while (anIndice < 50 && aFile == null) {
            aFile = new File(theTempDir, "GenicTemp" + anIndice);
            if (!aFile.exists()) continue;
            ++anIndice;
            aFile = null;
        }
        if (aFile == null) {
            throw new BuildException("Impossible to find a free temp directory for output.");
        }
        aFile.mkdirs();
        return aFile;
    }

    private void addAllFiles(File anOutputDir, String aCurrentDirOrFile, Hashtable someFiles) {
        File aFile = new File(anOutputDir, aCurrentDirOrFile);
        if (aFile.isDirectory()) {
            String aCurrentDir = "";
            if (aCurrentDirOrFile.length() > 0) {
                aCurrentDir = aCurrentDirOrFile + '/';
            }
            File[] theFiles = aFile.listFiles();
            int i = 0;
            while (i < theFiles.length) {
                this.addAllFiles(anOutputDir, aCurrentDir + theFiles[i].getName(), someFiles);
                ++i;
            }
        } else {
            someFiles.put(aCurrentDirOrFile, aFile);
        }
    }

    private void dellAllFiles(File aFile) {
        if (aFile.isDirectory()) {
            File[] someFiles = aFile.listFiles();
            int i = 0;
            while (i < someFiles.length) {
                this.dellAllFiles(someFiles[i]);
                ++i;
            }
        }
        aFile.delete();
    }

    private void dellAllFilesInside(File aFile) {
        if (aFile.isDirectory()) {
            File[] someFiles = aFile.listFiles();
            int i = 0;
            while (i < someFiles.length) {
                this.dellAllFiles(someFiles[i]);
                ++i;
            }
        }
    }

    static {
        JONAS_DD = JONAS_DD;
        GENIC_CLASS = GENIC_CLASS;
        OLD_GENIC_CLASS = OLD_GENIC_CLASS;
        DEFAULT_ORB = DEFAULT_ORB;
    }
}

