/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.optional.ejb.BorlandGenerateClient;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.EjbJar;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class BorlandDeploymentTool
extends GenericDeploymentTool
implements ExecuteStreamHandler {
    public static final String PUBLICID_BORLAND_EJB = "-//Inprise Corporation//DTD Enterprise JavaBeans 1.1//EN";
    protected static final String DEFAULT_BAS45_EJB11_DTD_LOCATION = "/com/inprise/j2ee/xml/dtds/ejb-jar.dtd";
    protected static final String DEFAULT_BAS_DTD_LOCATION = "/com/inprise/j2ee/xml/dtds/ejb-inprise.dtd";
    protected static final String BAS_DD = "ejb-inprise.xml";
    protected static final String JAVA2IIOP = "java2iiop";
    protected static final String VERIFY = "com.inprise.ejb.util.Verify";
    private String jarSuffix = "-ejb.jar";
    private String borlandDTD;
    private boolean java2iiopdebug = false;
    private boolean generateclient = false;
    private boolean verify = true;
    private String verifyArgs = "";
    private Hashtable _genfiles = new Hashtable();
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$optional$ejb$BorlandGenerateClient;

    public void setDebug(boolean debug) {
        this.java2iiopdebug = debug;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public void setSuffix(String inString) {
        this.jarSuffix = inString;
    }

    public void setVerifyArgs(String args) {
        this.verifyArgs = args;
    }

    public void setBASdtd(String inString) {
        this.borlandDTD = inString;
    }

    public void setGenerateclient(boolean b) {
        this.generateclient = b;
    }

    protected DescriptorHandler getBorlandDescriptorHandler(final File srcDir) {
        DescriptorHandler handler = new DescriptorHandler(this.getTask(), srcDir){

            protected void processElement() {
                if (this.currentElement.equals("type-storage")) {
                    String fileNameWithMETA = this.currentText;
                    String fileName = fileNameWithMETA.substring("META-INF/".length(), fileNameWithMETA.length());
                    File descriptorFile = new File(srcDir, fileName);
                    this.ejbFiles.put(fileNameWithMETA, descriptorFile);
                }
            }
        };
        handler.registerDTD(PUBLICID_BORLAND_EJB, this.borlandDTD == null ? DEFAULT_BAS_DTD_LOCATION : this.borlandDTD);
        Iterator i = this.getConfig().dtdLocations.iterator();
        while (i.hasNext()) {
            EjbJar.DTDLocation dtdLocation = (EjbJar.DTDLocation)((Object)i.next());
            handler.registerDTD(dtdLocation.getPublicId(), dtdLocation.getLocation());
        }
        return handler;
    }

    protected void addVendorFiles(Hashtable ejbFiles, String ddPrefix) {
        File borlandDD = new File(this.getConfig().descriptorDir, ddPrefix + BAS_DD);
        if (!borlandDD.exists()) {
            this.log("Unable to locate borland deployment descriptor. It was expected to be in " + borlandDD.getPath(), 1);
            return;
        }
        this.log("Borland specific file found " + borlandDD, 3);
        ejbFiles.put("META-INF/ejb-inprise.xml", borlandDD);
    }

    File getVendorOutputJarFile(String baseName) {
        return new File(this.getDestDir(), baseName + this.jarSuffix);
    }

    private void verifyBorlandJar(File sourceJar) {
        Java javaTask = null;
        this.log("verify " + sourceJar, 2);
        try {
            String args = this.verifyArgs;
            args = args + " " + sourceJar.getPath();
            javaTask = (Java)this.getTask().getProject().createTask("java");
            javaTask.setTaskName("verify");
            javaTask.setClassname(VERIFY);
            Commandline.Argument arguments = javaTask.createArg();
            arguments.setLine(args);
            Path classpath = this.getCombinedClasspath();
            if (classpath != null) {
                javaTask.setClasspath(classpath);
                javaTask.setFork(true);
            }
            this.log("Calling com.inprise.ejb.util.Verify for " + sourceJar.toString(), 3);
            javaTask.execute();
        }
        catch (Exception e) {
            String msg = "Exception while calling com.inprise.ejb.util.Verify Details: " + e.toString();
            throw new BuildException(msg, (Throwable)e);
        }
    }

    private void generateClient(File sourceJar) {
        this.getTask().getProject().addTaskDefinition("internal_bas_generateclient", class$org$apache$tools$ant$taskdefs$optional$ejb$BorlandGenerateClient == null ? (class$org$apache$tools$ant$taskdefs$optional$ejb$BorlandGenerateClient = BorlandDeploymentTool.class$("org.apache.tools.ant.taskdefs.optional.ejb.BorlandGenerateClient")) : class$org$apache$tools$ant$taskdefs$optional$ejb$BorlandGenerateClient);
        BorlandGenerateClient gentask = null;
        this.log("generate client for " + sourceJar, 2);
        try {
            gentask = (BorlandGenerateClient)this.getTask().getProject().createTask("internal_bas_generateclient");
            gentask.setEjbjar(sourceJar);
            gentask.setDebug(this.java2iiopdebug);
            Path classpath = this.getCombinedClasspath();
            if (classpath != null) {
                gentask.setClasspath(classpath);
            }
            gentask.setTaskName("generate client");
            gentask.execute();
        }
        catch (Exception e) {
            String msg = "Exception while calling com.inprise.ejb.util.Verify Details: " + e.toString();
            throw new BuildException(msg, (Throwable)e);
        }
    }

    private void buildBorlandStubs(Iterator ithomes, Hashtable files) {
        Execute execTask = null;
        execTask = new Execute((ExecuteStreamHandler)this);
        Project project = this.getTask().getProject();
        execTask.setAntRun(project);
        execTask.setWorkingDirectory(project.getBaseDir());
        Commandline commandline = new Commandline();
        commandline.setExecutable(JAVA2IIOP);
        if (this.java2iiopdebug) {
            commandline.createArgument().setValue("-VBJdebug");
        }
        commandline.createArgument().setValue("-VBJclasspath");
        commandline.createArgument().setPath(this.getCombinedClasspath());
        commandline.createArgument().setValue("-list_files");
        commandline.createArgument().setValue("-no_tie");
        commandline.createArgument().setValue("-root_dir");
        commandline.createArgument().setValue(this.getConfig().srcDir.getAbsolutePath());
        commandline.createArgument().setValue("-compile");
        while (ithomes.hasNext()) {
            commandline.createArgument().setValue(ithomes.next().toString());
        }
        try {
            this.log("Calling java2iiop", 3);
            this.log(commandline.describeCommand(), 4);
            execTask.setCommandline(commandline.getCommandline());
            int result = execTask.execute();
            if (result != 0) {
                String msg = "Failed executing java2iiop (ret code is " + result + ")";
                throw new BuildException(msg, this.getTask().getLocation());
            }
        }
        catch (IOException e) {
            this.log("java2iiop exception :" + e.getMessage(), 0);
            throw new BuildException((Throwable)e, this.getTask().getLocation());
        }
    }

    protected void writeJar(String baseName, File jarFile, Hashtable files, String publicId) throws BuildException {
        Vector<String> homes = new Vector<String>();
        Iterator it = files.keySet().iterator();
        while (it.hasNext()) {
            String clazz = (String)it.next();
            if (!clazz.endsWith("Home.class")) continue;
            String home = this.toClass(clazz);
            homes.add(home);
            this.log(" Home " + home, 3);
        }
        this.buildBorlandStubs(homes.iterator(), files);
        files.putAll(this._genfiles);
        super.writeJar(baseName, jarFile, files, publicId);
        if (this.verify) {
            this.verifyBorlandJar(jarFile);
        }
        if (this.generateclient) {
            this.generateClient(jarFile);
        }
    }

    private String toClass(String filename) {
        String classname = filename.substring(0, filename.lastIndexOf(".class"));
        classname = classname.replace('\\', '.');
        return classname;
    }

    private String toClassFile(String filename) {
        String classfile = filename.substring(0, filename.lastIndexOf(".java"));
        classfile = classfile + ".class";
        return classfile;
    }

    public void start() throws IOException {
    }

    public void stop() {
    }

    public void setProcessInputStream(OutputStream param1) throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    public void setProcessOutputStream(InputStream is) throws IOException {
        try {
            String javafile;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((javafile = reader.readLine()) != null) {
                void var3_4;
                this.log("buffer:" + (String)var3_4, 4);
                if (!var3_4.endsWith(".java")) continue;
                String classfile = this.toClassFile((String)var3_4);
                String key = classfile.substring(this.getConfig().srcDir.getAbsolutePath().length() + 1);
                this.log(" generated : " + classfile, 4);
                this.log(" key       : " + key, 4);
                this._genfiles.put(key, new File(classfile));
            }
            reader.close();
        }
        catch (Exception e) {
            String msg = "Exception while parsing  java2iiop output. Details: " + e.toString();
            throw new BuildException(msg, (Throwable)e);
        }
    }

    public void setProcessErrorStream(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String s = reader.readLine();
        if (s != null) {
            this.log("[java2iiop] " + s, 4);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PUBLICID_BORLAND_EJB = PUBLICID_BORLAND_EJB;
        DEFAULT_BAS45_EJB11_DTD_LOCATION = DEFAULT_BAS45_EJB11_DTD_LOCATION;
        DEFAULT_BAS_DTD_LOCATION = DEFAULT_BAS_DTD_LOCATION;
        BAS_DD = BAS_DD;
        JAVA2IIOP = JAVA2IIOP;
        VERIFY = VERIFY;
    }
}

