/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibConvolve3x3Or5x5OpImage;
import com.sun.media.jai.mlib.MlibConvolveOpImage;
import com.sun.media.jai.mlib.MlibSeparableConvolveOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

public class MlibConvolveRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        boolean bl;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        boolean bl2 = false;
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout, true) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            if (!MediaLibAccessor.isMediaLibBinaryCompatible(parameterBlock, imageLayout)) {
                return null;
            }
            bl2 = true;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        KernelJAI kernelJAI = (KernelJAI)parameterBlock.getObjectParameter(0);
        KernelJAI kernelJAI2 = kernelJAI.getRotatedKernel();
        int n = kernelJAI2.getWidth();
        int n2 = kernelJAI2.getHeight();
        if (n < 2 || n2 < 2) {
            return null;
        }
        boolean bl3 = bl = n == kernelJAI2.getXOrigin() * 2 + 1 && n2 == kernelJAI2.getYOrigin() * 2 + 1;
        if (!bl2 && kernelJAI2.isSeparable() && n >= 3 && n <= 7 && n == n2) {
            return new MlibSeparableConvolveOpImage(renderedImage, borderExtender, renderingHints, imageLayout, kernelJAI2);
        }
        if (n == 3 && n2 == 3 || !bl2 && n == 5 && n2 == 5) {
            return new MlibConvolve3x3Or5x5OpImage(renderedImage, borderExtender, renderingHints, imageLayout, kernelJAI2);
        }
        if (MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout, false)) {
            return new MlibConvolveOpImage(renderedImage, borderExtender, renderingHints, imageLayout, kernelJAI2);
        }
        return null;
    }
}

