/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.mapper;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import com.opensymphony.module.sitemesh.mapper.PathMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class ConfigLoader {
    private Map decorators;
    private long configLastModified;
    private File configFile;
    private String configFileName;
    private PathMapper pathMapper;
    private Config config;

    public ConfigLoader(String string, Config config) throws ServletException {
        this.config = config;
        this.configFileName = string;
        if (config.getServletContext().getRealPath(string) != null) {
            this.configFile = new File(config.getServletContext().getRealPath(string));
        }
        this.loadConfig();
    }

    public Decorator getDecoratorByName(String string) throws ServletException {
        this.refresh();
        return (Decorator)this.decorators.get(string);
    }

    public String getMappedName(String string) throws ServletException {
        this.refresh();
        return this.pathMapper.get(string);
    }

    private synchronized void loadConfig() throws ServletException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            if (this.configFile != null && this.configFile.canRead()) {
                this.configLastModified = this.configFile.lastModified();
                document = documentBuilder.parse(this.configFile);
            } else {
                document = documentBuilder.parse(this.config.getServletContext().getResourceAsStream(this.configFileName));
            }
            this.parseConfig(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServletException("Could not get XML parser", (Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new ServletException("Could not read config file: " + this.configFileName, (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            throw new ServletException("Could not parse config file: " + this.configFileName, (Throwable)sAXException);
        }
    }

    private synchronized void parseConfig(Document document) throws ServletException, SAXException {
        int n;
        NodeList nodeList;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Element element = document.getDocumentElement();
        String string = ConfigLoader.getAttribute(element, "defaultdir");
        if (string == null) {
            string = ConfigLoader.getAttribute(element, "defaultDir");
        }
        this.pathMapper = new PathMapper();
        this.decorators = new HashMap();
        NodeList nodeList2 = element.getElementsByTagName("decorator");
        Element element2 = null;
        int n2 = 0;
        while (n2 < nodeList2.getLength()) {
            object4 = null;
            String string2 = null;
            object3 = null;
            element2 = (Element)nodeList2.item(n2);
            if (ConfigLoader.getAttribute(element2, "name") != null) {
                Object object5;
                object4 = ConfigLoader.getAttribute(element2, "name");
                string2 = ConfigLoader.getAttribute(element2, "page");
                object3 = ConfigLoader.getAttribute(element2, "webapp");
                if (string != null && string2 != null && string2.length() > 0) {
                    string2 = string2.charAt(0) == '/' ? string + string2 : string + '/' + string2;
                }
                if (object3 != null && ((String)object3).length() > 0 && ((String)object3).charAt(0) != '/') {
                    object3 = '/' + (String)object3;
                }
                object2 = element2.getElementsByTagName("pattern");
                int n3 = 0;
                while (n3 < object2.getLength()) {
                    object5 = (Element)object2.item(n3);
                    String string3 = ((Text)object5.getFirstChild()).getData();
                    this.pathMapper.put((String)object4, string3);
                    ++n3;
                }
                object5 = element2.getElementsByTagName("url-pattern");
                int n4 = 0;
                while (n4 < object5.getLength()) {
                    object = (Element)object5.item(n4);
                    String string4 = ((Text)object.getFirstChild()).getData();
                    this.pathMapper.put((String)object4, string4);
                    ++n4;
                }
            } else {
                object4 = ConfigLoader.getContainedText(nodeList2.item(n2), "decorator-name");
                string2 = ConfigLoader.getContainedText(nodeList2.item(n2), "resource");
                if (string2 == null) {
                    string2 = ConfigLoader.getContainedText(nodeList2.item(n2), "jsp-file");
                }
            }
            object2 = new HashMap();
            nodeList = element2.getElementsByTagName("init-param");
            n = 0;
            while (n < nodeList.getLength()) {
                String string5 = ConfigLoader.getContainedText(nodeList.item(n), "param-name");
                object = ConfigLoader.getContainedText(nodeList.item(n), "param-value");
                object2.put(string5, object);
                ++n;
            }
            this.storeDecorator(new DefaultDecorator((String)object4, string2, (String)object3, (Map)object2));
            ++n2;
        }
        object4 = element.getElementsByTagName("decorator-mapping");
        int n5 = 0;
        while (n5 < object4.getLength()) {
            object3 = (Element)object4.item(n5);
            object2 = ConfigLoader.getContainedText(object4.item(n5), "decorator-name");
            nodeList = object3.getElementsByTagName("url-pattern");
            n = 0;
            while (n < nodeList.getLength()) {
                Element element3 = (Element)nodeList.item(n);
                object = ((Text)element3.getFirstChild()).getData();
                this.pathMapper.put((String)object2, (String)object);
                ++n;
            }
            ++n5;
        }
    }

    private static String getAttribute(Element element, String string) {
        if (element != null && element.getAttribute(string) != null && element.getAttribute(string).trim() != "") {
            return element.getAttribute(string).trim();
        }
        return null;
    }

    private static String getContainedText(Node node, String string) {
        try {
            Node node2 = ((Element)node).getElementsByTagName(string).item(0);
            String string2 = ((Text)node2.getFirstChild()).getData();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void storeDecorator(Decorator decorator) {
        this.decorators.put(decorator.getName(), decorator);
    }

    private synchronized void refresh() throws ServletException {
        if (this.configFile != null && this.configLastModified != this.configFile.lastModified()) {
            this.loadConfig();
        }
    }
}

