/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Parameter;
import org.hibernate.reflection.XMember;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.String2FieldBridgeAdaptor;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.BigDecimalBridge;
import org.hibernate.search.bridge.builtin.BigIntegerBridge;
import org.hibernate.search.bridge.builtin.DateBridge;
import org.hibernate.search.bridge.builtin.DoubleBridge;
import org.hibernate.search.bridge.builtin.FloatBridge;
import org.hibernate.search.bridge.builtin.IntegerBridge;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.search.bridge.builtin.ShortBridge;

public class BridgeFactory {
    private static Map<String, FieldBridge> builtInBridges = new HashMap<String, FieldBridge>();
    public static final TwoWayFieldBridge DOUBLE = new TwoWayString2FieldBridgeAdaptor(new DoubleBridge());
    public static final TwoWayFieldBridge FLOAT = new TwoWayString2FieldBridgeAdaptor(new FloatBridge());
    public static final TwoWayFieldBridge SHORT = new TwoWayString2FieldBridgeAdaptor(new ShortBridge());
    public static final TwoWayFieldBridge INTEGER = new TwoWayString2FieldBridgeAdaptor(new IntegerBridge());
    public static final TwoWayFieldBridge LONG = new TwoWayString2FieldBridgeAdaptor(new LongBridge());
    public static final TwoWayFieldBridge BIG_INTEGER = new TwoWayString2FieldBridgeAdaptor(new BigIntegerBridge());
    public static final TwoWayFieldBridge BIG_DECIMAL = new TwoWayString2FieldBridgeAdaptor(new BigDecimalBridge());
    public static final TwoWayFieldBridge STRING = new TwoWayString2FieldBridgeAdaptor(new org.hibernate.search.bridge.builtin.StringBridge());
    public static final FieldBridge DATE_YEAR = new String2FieldBridgeAdaptor(DateBridge.DATE_YEAR);
    public static final FieldBridge DATE_MONTH = new String2FieldBridgeAdaptor(DateBridge.DATE_MONTH);
    public static final FieldBridge DATE_DAY = new String2FieldBridgeAdaptor(DateBridge.DATE_DAY);
    public static final FieldBridge DATE_HOUR = new String2FieldBridgeAdaptor(DateBridge.DATE_HOUR);
    public static final FieldBridge DATE_MINUTE = new String2FieldBridgeAdaptor(DateBridge.DATE_MINUTE);
    public static final FieldBridge DATE_SECOND = new String2FieldBridgeAdaptor(DateBridge.DATE_SECOND);
    public static final TwoWayFieldBridge DATE_MILLISECOND = new TwoWayString2FieldBridgeAdaptor(DateBridge.DATE_MILLISECOND);

    private BridgeFactory() {
    }

    /*
     * Unable to fully structure code
     */
    public static FieldBridge guessType(XMember member) {
        bridge = null;
        bridgeAnn = (org.hibernate.search.annotations.FieldBridge)member.getAnnotation(org.hibernate.search.annotations.FieldBridge.class);
        if (bridgeAnn != null) {
            impl = bridgeAnn.impl();
            try {
                instance = impl.newInstance();
                if (FieldBridge.class.isAssignableFrom(impl)) {
                    bridge = (FieldBridge)instance;
                } else if (TwoWayStringBridge.class.isAssignableFrom(impl)) {
                    bridge = new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)instance);
                } else if (StringBridge.class.isAssignableFrom(impl)) {
                    bridge = new String2FieldBridgeAdaptor((StringBridge)instance);
                }
                if (bridgeAnn.params().length <= 0 || !ParameterizedBridge.class.isAssignableFrom(impl)) ** GOTO lbl31
                params = new HashMap<String, String>(bridgeAnn.params().length);
                for (Parameter param : bridgeAnn.params()) {
                    params.put(param.name(), param.value());
                }
                ((ParameterizedBridge)instance).setParameterValues(params);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to instanciate FieldBridge for " + member.getName(), (Throwable)e);
            }
        } else if (member.isAnnotationPresent(org.hibernate.search.annotations.DateBridge.class)) {
            resolution = ((org.hibernate.search.annotations.DateBridge)member.getAnnotation(org.hibernate.search.annotations.DateBridge.class)).resolution();
            bridge = BridgeFactory.getDateField(resolution);
        } else {
            returnType = member.getType();
            bridge = BridgeFactory.builtInBridges.get(returnType.getName());
        }
lbl31:
        // 4 sources

        if (bridge == null) {
            throw new HibernateException("Unable to guess FieldBridge for " + member.getName());
        }
        return bridge;
    }

    public static FieldBridge getDateField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return DATE_YEAR;
            }
            case MONTH: {
                return DATE_MONTH;
            }
            case DAY: {
                return DATE_DAY;
            }
            case HOUR: {
                return DATE_HOUR;
            }
            case MINUTE: {
                return DATE_MINUTE;
            }
            case SECOND: {
                return DATE_SECOND;
            }
            case MILLISECOND: {
                return DATE_MILLISECOND;
            }
        }
        throw new AssertionFailure("Unknown Resolution: " + (Object)((Object)resolution));
    }

    static {
        builtInBridges.put(Double.class.getName(), DOUBLE);
        builtInBridges.put(Double.TYPE.getName(), DOUBLE);
        builtInBridges.put(Float.class.getName(), FLOAT);
        builtInBridges.put(Float.TYPE.getName(), FLOAT);
        builtInBridges.put(Short.class.getName(), SHORT);
        builtInBridges.put(Short.TYPE.getName(), SHORT);
        builtInBridges.put(Integer.class.getName(), INTEGER);
        builtInBridges.put(Integer.TYPE.getName(), INTEGER);
        builtInBridges.put(Long.class.getName(), LONG);
        builtInBridges.put(Long.TYPE.getName(), LONG);
        builtInBridges.put(BigInteger.class.getName(), BIG_INTEGER);
        builtInBridges.put(BigDecimal.class.getName(), BIG_DECIMAL);
        builtInBridges.put(String.class.getName(), STRING);
        builtInBridges.put(Date.class.getName(), DATE_MILLISECOND);
    }
}

