/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.BasicAuthenticationRequiredException;
import com.meterware.servletunit.InvocationContext;
import com.meterware.servletunit.ServletRunner;
import com.meterware.servletunit.ServletUnitHttpRequest;
import com.meterware.servletunit.ServletUnitHttpResponse;
import com.meterware.servletunit.ServletUnitHttpSession;
import com.meterware.servletunit.ServletUnitWebResponse;
import com.meterware.servletunit.WebApplication;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

class InvocationContextImpl
implements InvocationContext {
    private WebApplication _application;
    private ServletUnitHttpRequest _request;
    private ServletUnitHttpResponse _response = new ServletUnitHttpResponse();
    private URL _requestURL;
    private String _target;
    private Servlet _servlet;
    private WebResponse _webResponse;

    public HttpServletRequest getRequest() {
        return this._request;
    }

    public HttpServletResponse getResponse() {
        return this._response;
    }

    public Servlet getServlet() throws ServletException {
        if (this._servlet == null) {
            if (!this._application.requiresAuthorization(this._requestURL) || this.userIsAuthorized()) {
                this._servlet = this._application.getServletRequest(this._requestURL).getServlet();
            } else {
                if (this._request.getRemoteUser() != null) {
                    throw new AccessDeniedException(this._requestURL);
                }
                if (this._application.usesBasicAuthentication()) {
                    throw new BasicAuthenticationRequiredException(this._application.getAuthenticationRealm());
                }
                if (this._application.usesFormAuthentication()) {
                    this._servlet = this._application.getServletRequest(this._application.getLoginURL()).getServlet();
                    ((ServletUnitHttpRequest)this.getRequest()).setOriginalURL(this._requestURL);
                } else {
                    throw new IllegalStateException("Authorization required but no authentication method defined");
                }
            }
        }
        return this._servlet;
    }

    public WebResponse getServletResponse() throws IOException {
        if (this._webResponse == null) {
            HttpSession session = this._request.getSession(false);
            if (session != null && session.isNew()) {
                this._response.addCookie(new Cookie("JSESSION", session.getId()));
            }
            this._webResponse = new ServletUnitWebResponse(this._target, this._requestURL, this._response);
        }
        return this._webResponse;
    }

    public String getTarget() {
        return this._target;
    }

    private boolean userIsAuthorized() {
        String[] roles = this._request.getRoles();
        int i = 0;
        while (i < roles.length) {
            if (this._application.roleMayAccess(roles[i], this._requestURL)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    InvocationContextImpl(ServletRunner runner, WebRequest request, Cookie[] cookies, Dictionary clientHeaders, byte[] messageBody) throws IOException, MalformedURLException {
        this._application = runner._application;
        this._requestURL = request.getURL();
        this._target = request.getTarget();
        this._request = new ServletUnitHttpRequest(this._application.getServletRequest(this._requestURL), request, runner.getContext(), clientHeaders, messageBody);
        int i = 0;
        while (i < cookies.length) {
            this._request.addCookie(cookies[i]);
            ++i;
        }
        if (this._application.usesBasicAuthentication()) {
            this._request.readBasicAuthentication();
        } else if (this._application.usesFormAuthentication()) {
            this._request.readFormAuthentication();
        }
        HttpSession session = this._request.getSession(false);
        if (session != null) {
            ((ServletUnitHttpSession)session).access();
        }
    }

    class AccessDeniedException
    extends HttpException {
        public AccessDeniedException(URL baseURL) {
            super(403, "Access Denied", baseURL);
        }
    }
}

