/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class NumberComboBoxEditor
extends BasicComboBoxEditor {
    private static final String EMPTY_STRING = "".intern();

    public NumberComboBoxEditor(final int value, int columns) {
        final NumberTextField textField = new NumberTextField(value, columns);
        textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent ev) {
                String test = textField.getText();
                if (test == null || EMPTY_STRING.equals(test.trim())) {
                    textField.setText(String.valueOf(value));
                }
            }
        });
        this.editor = textField;
    }

    private static class NumberTextField
    extends JTextField {
        final int initialValue;
        NumberFormat integerFormatter;

        public NumberTextField(int value, int columns) {
            super(columns);
            NumberDocument document = (NumberDocument)this.getDocument();
            this.initialValue = value;
            document.initialValue = value;
            this.integerFormatter = NumberFormat.getNumberInstance();
            this.integerFormatter.setParseIntegerOnly(true);
            this.setValue(value);
        }

        public void setValue(int value) {
            this.setText(this.integerFormatter.format(value));
        }

        public int getValue() {
            try {
                return this.integerFormatter.parse(this.getText()).intValue();
            }
            catch (ParseException ex) {
                return this.initialValue;
            }
        }

        protected Document createDefaultModel() {
            return new NumberDocument();
        }

        private static class NumberDocument
        extends PlainDocument {
            int initialValue;

            public void insertString(int offs, String str, AttributeSet atts) throws BadLocationException {
                char[] source = str.toCharArray();
                char[] result = new char[source.length];
                int j = 0;
                int i = 0;
                while (i < result.length) {
                    if (Character.isDigit(source[i])) {
                        result[j++] = source[i];
                    } else if (offs == 0) {
                        super.insertString(offs, String.valueOf(this.initialValue), atts);
                        return;
                    }
                    ++i;
                }
                super.insertString(offs, new String(result, 0, j), atts);
            }
        }
    }
}

