/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.History;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.ComboBoxPanel;
import de.hunsicker.jalopy.swing.HistoryViewer;
import de.hunsicker.jalopy.swing.LocationDialog;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.EmptyButtonGroup;
import de.hunsicker.swing.ErrorDialog;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MiscSettingsPage
extends AbstractSettingsPage {
    private static final String EMPTY_STRING = "".intern();
    private static final String FILENAME_BACKUP = "backup.dat";
    private JCheckBox _arrayBracketsAfterIdentifierCheckBox;
    private JCheckBox _forceCheckBox;
    private JCheckBox _historyCommentCheckBox;
    private JCheckBox _historyFileCheckBox;
    private JCheckBox _insertConditionalCheckBox;
    private JCheckBox _insertParenCheckBox;
    private JCheckBox _insertTrailingNewlineCheckBox;
    private JCheckBox _insertUIDCheckBox;
    private JComboBox _historyMethodComboBox;
    private JSlider _backupSlider;
    private JSlider _threadSlider;
    private JTextField _directoryTextField;

    public MiscSettingsPage() {
        this.initialize();
    }

    MiscSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public void updateSettings() {
        this.settings.putBoolean(ConventionKeys.INSERT_EXPRESSION_PARENTHESIS, this._insertParenCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.FORCE_FORMATTING, this._forceCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.INSERT_TRAILING_NEWLINE, this._insertTrailingNewlineCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.ARRAY_BRACKETS_AFTER_IDENT, this._arrayBracketsAfterIdentifierCheckBox.isSelected());
        this.settings.putInt(ConventionKeys.BACKUP_LEVEL, this._backupSlider.getValue());
        this.settings.putInt(ConventionKeys.THREAD_COUNT, this._threadSlider.getValue());
        String directoryPath = this._directoryTextField.getText();
        if (directoryPath.startsWith(Convention.getProjectSettingsDirectory().getAbsolutePath())) {
            directoryPath = directoryPath.substring(Convention.getProjectSettingsDirectory().getAbsolutePath().length() + 1);
        }
        this.settings.put(ConventionKeys.BACKUP_DIRECTORY, directoryPath);
        this.settings.putBoolean(ConventionKeys.INSERT_SERIAL_UID, this._insertUIDCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.INSERT_LOGGING_CONDITIONAL, this._insertConditionalCheckBox.isSelected());
        if (this._historyCommentCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.HISTORY_POLICY, History.Policy.COMMENT.getName());
        } else if (this._historyFileCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.HISTORY_POLICY, History.Policy.FILE.getName());
            History.Method historyMethod = (History.Method)this._historyMethodComboBox.getSelectedItem();
            this.settings.put(ConventionKeys.HISTORY_METHOD, historyMethod.getName());
        } else {
            this.settings.put(ConventionKeys.HISTORY_POLICY, History.Policy.DISABLED.getName());
        }
    }

    private JPanel createBackupPanel() {
        JPanel backupPanel = new JPanel();
        backupPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_BACKUP")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout backupLayout = new GridBagLayout();
        backupPanel.setLayout(backupLayout);
        GridBagConstraints c = new GridBagConstraints();
        JLabel backupLbl = new JLabel(this.bundle.getString("LBL_BACKUP_LEVEL"));
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 0.0, 0.0, 17, 2, c.insets, 0, 0);
        backupLayout.setConstraints(backupLbl, c);
        backupPanel.add(backupLbl);
        this._backupSlider = new JSlider(0, 0, 30, this.settings.getInt(ConventionKeys.BACKUP_LEVEL, 0));
        this._backupSlider.setSnapToTicks(true);
        c.insets.left = 10;
        c.insets.right = 10;
        SwingHelper.setConstraints(c, 1, 0, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        backupLayout.setConstraints(this._backupSlider, c);
        backupPanel.add(this._backupSlider);
        final NumberedLabel backupLevelLabel = new NumberedLabel(this.settings.getInt(ConventionKeys.BACKUP_LEVEL, 0), this.bundle.getString("LBL_BACKUP_SINGULAR"), this.bundle.getString("LBL_BACKUP_PLURAL"));
        this._backupSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                JSlider source = (JSlider)ev.getSource();
                int level = source.getValue();
                backupLevelLabel.setLevel(level);
            }
        });
        c.insets.left = 0;
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 2, 0, 0, 1, 0.0, 0.0, 13, 2, c.insets, 0, 0);
        backupLayout.setConstraints(backupLevelLabel, c);
        backupPanel.add(backupLevelLabel);
        c.insets.top = 10;
        JLabel directoryLbl = new JLabel(this.bundle.getString("LBL_BACKUP_DIRECTORY"));
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        backupLayout.setConstraints(directoryLbl, c);
        backupPanel.add(directoryLbl);
        String directoryPath = this.settings.get(ConventionKeys.BACKUP_DIRECTORY, Convention.getBackupDirectory().getAbsolutePath());
        File directoryFile = new File(directoryPath);
        if (!directoryFile.isAbsolute()) {
            directoryPath = new File(Convention.getProjectSettingsDirectory(), directoryPath).getAbsolutePath();
        }
        this._directoryTextField = new JTextField(directoryPath);
        this._directoryTextField.setCaretPosition(1);
        this._directoryTextField.setEditable(false);
        this._directoryTextField.setToolTipText(this._directoryTextField.getText());
        c.insets.left = 10;
        c.insets.right = 10;
        SwingHelper.setConstraints(c, 1, 1, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        backupLayout.setConstraints(this._directoryTextField, c);
        backupPanel.add(this._directoryTextField);
        JButton chooseButton = SwingHelper.createButton(this.bundle.getString("BTN_CHOOSE"));
        c.insets.left = 0;
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 2, 1, 0, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        backupLayout.setConstraints(chooseButton, c);
        backupPanel.add(chooseButton);
        chooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Window owner = SwingUtilities.windowForComponent(MiscSettingsPage.this);
                String backupHistory = LocationDialog.loadHistory(new File(Convention.getProjectSettingsDirectory(), MiscSettingsPage.FILENAME_BACKUP));
                if (EMPTY_STRING.equals(backupHistory)) {
                    backupHistory = Convention.getBackupDirectory().getAbsolutePath();
                }
                LocationDialog dialog = LocationDialog.create(owner, MiscSettingsPage.this.bundle.getString("TLE_SELECT_BACKUP_DIRECTORY"), "XXX", backupHistory);
                dialog.setFileChooserProperties(4);
                dialog.setVisible(true);
                switch (dialog.getOption()) {
                    case 0: {
                        try {
                            String location = (String)dialog.getSelectedLocation();
                            if (location != null && location.length() > 0) {
                                File file = new File(location);
                                if (!IoHelper.ensureDirectoryExists(file)) {
                                    return;
                                }
                                MiscSettingsPage.this._directoryTextField.setText(file.getAbsolutePath());
                                MiscSettingsPage.this._directoryTextField.setToolTipText(file.getAbsolutePath());
                                LocationDialog.storeHistory(new File(Convention.getProjectSettingsDirectory(), MiscSettingsPage.FILENAME_BACKUP), dialog.getHistoryString());
                            }
                            dialog.dispose();
                            break;
                        }
                        catch (Throwable ex) {
                            ErrorDialog d = ErrorDialog.create(owner, ex);
                            d.setVisible(true);
                            d.dispose();
                        }
                    }
                }
            }
        });
        return backupPanel;
    }

    private JPanel createHistoryPanel() {
        JPanel historyPanel = new JPanel();
        historyPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_HISTORY")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        History.Policy historyPolicy = History.Policy.valueOf(this.settings.get(ConventionKeys.HISTORY_POLICY, ConventionDefaults.HISTORY_POLICY));
        GridBagLayout historyLayout = new GridBagLayout();
        historyPanel.setLayout(historyLayout);
        GridBagConstraints c = new GridBagConstraints();
        this._historyFileCheckBox = new JCheckBox(this.bundle.getString("CHK_USE_HISTORY_FILE"), historyPolicy == History.Policy.FILE);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        historyLayout.setConstraints(this._historyFileCheckBox, c);
        historyPanel.add(this._historyFileCheckBox);
        History.Method historyMethod = History.Method.valueOf(this.settings.get(ConventionKeys.HISTORY_METHOD, ConventionDefaults.HISTORY_METHOD));
        ComboBoxPanel historyMethodCombo = new ComboBoxPanel("method", new Object[]{History.Method.TIMESTAMP, History.Method.CRC32, History.Method.ADLER32}, historyMethod);
        this._historyMethodComboBox = historyMethodCombo.getComboBox();
        this._historyMethodComboBox.setEnabled(this._historyFileCheckBox.isSelected());
        SwingHelper.setConstraints(c, 1, 0, 1, 1, 0.5, 0.0, 10, 2, c.insets, 0, 0);
        historyLayout.setConstraints(this._historyMethodComboBox, c);
        historyPanel.add(this._historyMethodComboBox);
        final JButton browseButton = SwingHelper.createButton(this.bundle.getString("BTN_DLG_VIEW"));
        browseButton.setEnabled(this._historyFileCheckBox.isSelected());
        this._historyFileCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (MiscSettingsPage.this._historyFileCheckBox.isSelected()) {
                    browseButton.setEnabled(true);
                    MiscSettingsPage.this._historyMethodComboBox.setEnabled(true);
                } else {
                    browseButton.setEnabled(false);
                    MiscSettingsPage.this._historyMethodComboBox.setEnabled(false);
                }
            }
        });
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDialog dialog = null;
                Window owner = SwingUtilities.windowForComponent(MiscSettingsPage.this);
                dialog = owner instanceof Dialog ? new JDialog((Dialog)owner, MiscSettingsPage.this.bundle.getString("TLE_HISTORY_VIEWER")) : new JDialog((Frame)owner, MiscSettingsPage.this.bundle.getString("TLE_HISTORY_VIEWER"));
                dialog.setDefaultCloseOperation(2);
                dialog.getContentPane().add(new HistoryViewer());
                dialog.setModal(true);
                dialog.pack();
                dialog.setLocationRelativeTo(owner);
                dialog.setVisible(true);
                dialog.dispose();
            }
        });
        SwingHelper.setConstraints(c, 2, 0, 0, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
        historyLayout.setConstraints(browseButton, c);
        historyPanel.add(browseButton);
        this._historyCommentCheckBox = new JCheckBox(this.bundle.getString("CHK_USE_HISTORY_COMMENT"), historyPolicy == History.Policy.COMMENT);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        historyLayout.setConstraints(this._historyCommentCheckBox, c);
        historyPanel.add(this._historyCommentCheckBox);
        EmptyButtonGroup historyCheckBoxGroup = new EmptyButtonGroup();
        ((ButtonGroup)historyCheckBoxGroup).add(this._historyCommentCheckBox);
        ((ButtonGroup)historyCheckBoxGroup).add(this._historyFileCheckBox);
        return historyPanel;
    }

    private JPanel createThreadPanel() {
        JPanel threadPanel = new JPanel();
        threadPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_THREADS")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout threadPanelLayout = new GridBagLayout();
        threadPanel.setLayout(threadPanelLayout);
        GridBagConstraints c = new GridBagConstraints();
        JLabel threadLabel = new JLabel(this.bundle.getString("LBL_THREADS_NUMBER"));
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
        threadPanelLayout.setConstraints(threadLabel, c);
        threadPanel.add(threadLabel);
        this._threadSlider = new JSlider(0, 1, 8, this.settings.getInt(ConventionKeys.THREAD_COUNT, 1));
        this._threadSlider.setLabelTable(this._threadSlider.createStandardLabels(1, 1));
        this._threadSlider.setMajorTickSpacing(7);
        this._threadSlider.setMinorTickSpacing(1);
        this._threadSlider.setSnapToTicks(true);
        c.insets.left = 10;
        c.insets.top = 0;
        c.insets.right = 10;
        c.insets.bottom = 0;
        SwingHelper.setConstraints(c, 1, 0, 1, 1, 0.5, 0.0, 10, 2, c.insets, 0, 0);
        threadPanelLayout.setConstraints(this._threadSlider, c);
        threadPanel.add(this._threadSlider);
        final NumberedLabel backupLevelLabel = new NumberedLabel(this.settings.getInt(ConventionKeys.THREAD_COUNT, 1), this.bundle.getString("LBL_THREADS_SINGULAR"), this.bundle.getString("LBL_THREADS_PLURAL"));
        this._threadSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                JSlider source = (JSlider)ev.getSource();
                int level = source.getValue();
                backupLevelLabel.setLevel(level);
            }
        });
        c.insets.left = 0;
        c.insets.right = 15;
        SwingHelper.setConstraints(c, 2, 0, 0, 1, 0.0, 0.0, 13, 2, c.insets, 0, 0);
        threadPanelLayout.setConstraints(backupLevelLabel, c);
        threadPanel.add(backupLevelLabel);
        return threadPanel;
    }

    private void initialize() {
        JPanel removePanel = new JPanel();
        GridBagLayout removeLayout = new GridBagLayout();
        removePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_MISC")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        removePanel.setLayout(removeLayout);
        GridBagConstraints c = new GridBagConstraints();
        this._insertParenCheckBox = new JCheckBox(this.bundle.getString("CHK_INSERT_PARENTHESES"), this.settings.getBoolean(ConventionKeys.INSERT_EXPRESSION_PARENTHESIS, true));
        this._insertParenCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        removeLayout.setConstraints(this._insertParenCheckBox, c);
        removePanel.add(this._insertParenCheckBox);
        this._insertUIDCheckBox = new JCheckBox(this.bundle.getString("CHK_INSERT_SERIAL_UID"), this.settings.getBoolean(ConventionKeys.INSERT_SERIAL_UID, false));
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        removeLayout.setConstraints(this._insertUIDCheckBox, c);
        removePanel.add(this._insertUIDCheckBox);
        this._insertConditionalCheckBox = new JCheckBox(this.bundle.getString("CHK_INSERT_LOGGING_CONDITIONAL"), this.settings.getBoolean(ConventionKeys.INSERT_LOGGING_CONDITIONAL, false));
        this._insertConditionalCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        removeLayout.setConstraints(this._insertConditionalCheckBox, c);
        removePanel.add(this._insertConditionalCheckBox);
        this._insertTrailingNewlineCheckBox = new JCheckBox(this.bundle.getString("CHK_INSERT_TRAILING_NEWLINE"), this.settings.getBoolean(ConventionKeys.INSERT_TRAILING_NEWLINE, true));
        this._insertTrailingNewlineCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        removeLayout.setConstraints(this._insertTrailingNewlineCheckBox, c);
        removePanel.add(this._insertTrailingNewlineCheckBox);
        this._arrayBracketsAfterIdentifierCheckBox = new JCheckBox(this.bundle.getString("CHK_BRACKETS_AFTER_IDENTIFIER"), this.settings.getBoolean(ConventionKeys.ARRAY_BRACKETS_AFTER_IDENT, false));
        this._arrayBracketsAfterIdentifierCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 2, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        removeLayout.setConstraints(this._arrayBracketsAfterIdentifierCheckBox, c);
        removePanel.add(this._arrayBracketsAfterIdentifierCheckBox);
        this._forceCheckBox = new JCheckBox(this.bundle.getString("CHK_FORCE_FORMATTING"), this.settings.getBoolean(ConventionKeys.FORCE_FORMATTING, false));
        SwingHelper.setConstraints(c, 1, 2, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        removeLayout.setConstraints(this._forceCheckBox, c);
        removePanel.add(this._forceCheckBox);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        c.insets.top = 10;
        c.insets.bottom = 10;
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(removePanel, c);
        this.add(removePanel);
        c.insets.top = 0;
        JPanel historyPanel = this.createHistoryPanel();
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(historyPanel, c);
        this.add(historyPanel);
        JPanel backupPanel = this.createBackupPanel();
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(backupPanel, c);
        this.add(backupPanel);
        JPanel threadPanel = this.createThreadPanel();
        SwingHelper.setConstraints(c, 0, 3, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(threadPanel, c);
        this.add(threadPanel);
    }

    private static class NumberedLabel
    extends JLabel {
        String plural;
        String singular;
        int level;

        public NumberedLabel(int level, String singular, String plural) {
            this.singular = singular;
            this.plural = plural;
            this.setLevel(level);
        }

        public void setLevel(int level) {
            this.level = level;
            super.setText(level != 1 ? "" + level + ' ' + this.plural : "" + level + ' ' + this.singular);
        }

        public void setText(String text) {
        }
    }
}

