/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.LeftParenthesisPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.PrinterHelper;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class MethodCallPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new MethodCallPrinter();

    protected MethodCallPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public static JavaNode getLastMethodCall(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 69: {
                return MethodCallPrinter.getLastMethodCall(parent.getParent());
            }
        }
        return node;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST identifier;
        boolean continuation = out.continuation;
        boolean lastInChain = false;
        ParenthesesScope scope = null;
        AST first = node.getFirstChild();
        if (out.mode == 1) {
            boolean wrapLines = settings.getBoolean(ConventionKeys.LINE_WRAP, true);
            boolean forceWrappingForChainedCalls = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_CHAINED_METHOD_CALL, false);
            if ((wrapLines || forceWrappingForChainedCalls) && JavaNodeHelper.isChained(first)) {
                AST firstLink = JavaNodeHelper.getFirstChainLink(node);
                scope = (ParenthesesScope)out.state.parenScope.getFirst();
                if (scope.chainCall == null) {
                    scope.chainCall = firstLink;
                    AST child = firstLink.getFirstChild();
                    switch (child.getType()) {
                        case 69: {
                            TestNodeWriter tester = out.testers.get();
                            identifier = child.getFirstChild();
                            PrinterFactory.create(identifier).print(identifier, tester);
                            scope.chainOffset = out.column - 1 + tester.length;
                            out.testers.release(tester);
                            break;
                        }
                        default: {
                            scope.chainOffset = out.column - 1 + out.indentSize;
                        }
                    }
                    if (out.newline) {
                        scope.chainOffset += out.getIndentLength();
                    }
                    lastInChain = true;
                }
            }
        }
        boolean innerClass = false;
        Marker marker = null;
        JavaNode parent = ((JavaNode)node).getParent();
        switch (parent.getType()) {
            default: {
                marker = out.state.markers.add();
                break;
            }
            case 27: {
                AST next = parent.getFirstChild();
                AST type = null;
                switch (next.getType()) {
                    case 84: {
                        type = PrinterHelper.advanceToFirstNonParen(next);
                        break;
                    }
                    default: {
                        type = next;
                    }
                }
                identifier = type.getFirstChild();
                int length = 0;
                switch (identifier.getType()) {
                    case 68: {
                        length = identifier.getText().length();
                        break;
                    }
                    case 21: {
                        length = identifier.getFirstChild().getText().length();
                        if (!settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACKETS_TYPES, false)) break;
                        ++length;
                        break;
                    }
                    case 60: {
                        length = 7;
                        break;
                    }
                    case 61: 
                    case 62: 
                    case 66: {
                        length = 4;
                        break;
                    }
                    case 63: 
                    case 65: {
                        length = 5;
                        break;
                    }
                    case 64: {
                        length = 3;
                        break;
                    }
                    case 67: {
                        length = 6;
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected TYPE, was " + type);
                    }
                }
                if (settings.getBoolean(ConventionKeys.PADDING_CAST, false)) {
                    length += 2;
                }
                if (settings.getBoolean(ConventionKeys.SPACE_AFTER_CAST, true)) {
                    ++length;
                }
                marker = out.state.markers.add(out.line, out.column - 3 - length);
            }
        }
        this.logIssues(node, out);
        PrinterFactory.create(first).print(first, out);
        if (settings.getBoolean(ConventionKeys.SPACE_BEFORE_METHOD_CALL_PAREN, false)) {
            out.print(" ", 153);
        }
        LeftParenthesisPrinter.getInstance().print(node, out);
        AST elist = first.getNextSibling();
        PrinterFactory.create(elist).print(elist, out);
        if (out.last == 18) {
            innerClass = true;
        }
        AST rparen = elist.getNextSibling();
        PrinterFactory.create(rparen).print(rparen, out);
        if (innerClass) {
            out.last = 18;
        }
        out.state.markers.remove(marker);
        if (lastInChain && scope != null) {
            scope.chainCall = null;
        }
        if (out.continuation && !continuation) {
            out.continuation = false;
        }
    }

    static AST getChainParent(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 32: 
            case 135: {
                return MethodCallPrinter.getChainParent(parent);
            }
        }
        return parent;
    }

    static boolean isOuterMethodCall(AST node) {
        JavaNode call = MethodCallPrinter.getLastMethodCall((JavaNode)node);
        if (call.getPreviousSibling().getType() == 84) {
            return false;
        }
        JavaNode expr = call.getParent();
        return MethodCallPrinter.getChainParent(expr).getType() != 38;
    }
}

