/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.CommonHiddenStreamToken;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import de.hunsicker.jalopy.storage.History;
import de.hunsicker.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

final class JavaPrinter
extends AbstractPrinter {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Printer INSTANCE = new JavaPrinter();
    private static final String DELIMETER = "|";

    protected JavaPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        out.environment.set(Environment.Variable.CONVENTION.getName(), settings.get(ConventionKeys.CONVENTION_NAME, "Sun"));
        try {
            boolean useFooter;
            History.Policy historyPolicy = History.Policy.valueOf(settings.get(ConventionKeys.HISTORY_POLICY, ConventionDefaults.HISTORY_POLICY));
            boolean useCommentHistory = historyPolicy == History.Policy.COMMENT;
            boolean useHeader = settings.getBoolean(ConventionKeys.HEADER, false);
            if (useHeader || useCommentHistory) {
                this.removeHeader(node);
            }
            if (useHeader) {
                this.printHeader(out);
            }
            if (useFooter = settings.getBoolean(ConventionKeys.FOOTER, false)) {
                this.removeFooter(node);
            }
            AST child = node.getFirstChild();
            while (child != null) {
                PrinterFactory.create(child).print(child, out);
                child = child.getNextSibling();
            }
            if (useFooter) {
                this.printFooter(out);
            }
            Object var9_8 = null;
            out.environment.unset(Environment.Variable.CONVENTION.getName());
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            out.environment.unset(Environment.Variable.CONVENTION.getName());
            throw throwable;
        }
    }

    private String[] getConventionKeys(Convention.Key key) {
        ArrayList<Object> keys = new ArrayList<Object>();
        String str = settings.get(key, AbstractPrinter.EMPTY_STRING);
        StringTokenizer tokens = new StringTokenizer(str, DELIMETER);
        while (tokens.hasMoreElements()) {
            keys.add(tokens.nextElement());
        }
        return keys.toArray(EMPTY_STRING_ARRAY);
    }

    private JavaNode getLastElement(AST root) {
        AST declaration = root.getFirstChild();
        while (declaration != null) {
            if (declaration.getNextSibling() == null) {
                switch (declaration.getType()) {
                    case 18: 
                    case 19: {
                        AST block = JavaNodeHelper.getFirstChild(declaration, 10);
                        AST element = block.getFirstChild();
                        while (element != null) {
                            if (element.getNextSibling() == null) {
                                switch (element.getType()) {
                                    case 8: {
                                        return (JavaNode)element;
                                    }
                                }
                            }
                            element = element.getNextSibling();
                        }
                        break;
                    }
                    case 55: {
                        return (JavaNode)declaration;
                    }
                    case 20: 
                    case 34: {
                        return (JavaNode)declaration;
                    }
                }
            }
            declaration = declaration.getNextSibling();
        }
        throw new IllegalStateException("invalid AST -- " + root);
    }

    private void printFooter(NodeWriter out) throws IOException {
        String text = out.environment.interpolate(settings.get(ConventionKeys.FOOTER_TEXT, AbstractPrinter.EMPTY_STRING));
        String[] footer = StringHelper.split(text, DELIMETER);
        if (footer.length > 0) {
            switch (out.last) {
                case 8: 
                case 10: 
                case 18: 
                case 19: {
                    out.printNewline();
                }
            }
            out.printBlankLines(settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_FOOTER, 1));
            int i = 0;
            while (i < footer.length) {
                out.print(footer[i], 157);
                if (i < footer.length - 1) {
                    out.printNewline();
                }
                ++i;
            }
            int blankLinesAfter = settings.getInt(ConventionKeys.BLANK_LINES_AFTER_FOOTER, 1);
            if (blankLinesAfter == 0) {
                blankLinesAfter = 1;
            }
            out.printBlankLines(blankLinesAfter);
        }
    }

    private void printHeader(NodeWriter out) throws IOException {
        String text = out.environment.interpolate(settings.get(ConventionKeys.HEADER_TEXT, AbstractPrinter.EMPTY_STRING));
        String[] header = StringHelper.split(text, DELIMETER);
        if (header.length > 0) {
            out.printBlankLines(settings.getInt(ConventionKeys.BLANK_LINES_BEFORE_HEADER, 0));
            int i = 0;
            while (i < header.length) {
                out.print(header[i], 157);
                out.printNewline();
                ++i;
            }
            out.printBlankLines(settings.getInt(ConventionKeys.BLANK_LINES_AFTER_HEADER, 0));
            out.last = 157;
        }
    }

    private void removeFooter(AST root) {
        JavaNode rcurly = this.getLastElement(root);
        if (rcurly.hasCommentsAfter()) {
            String[] keys = this.getConventionKeys(ConventionKeys.FOOTER_KEYS);
            int count = 0;
            int smartModeLines = settings.getInt(ConventionKeys.FOOTER_SMART_MODE_LINES, 0);
            boolean smartMode = smartModeLines > 0;
            CommonHiddenStreamToken comment = rcurly.getHiddenAfter();
            while (comment != null) {
                switch (comment.getType()) {
                    case 52: 
                    case 154: 
                    case 155: {
                        if (smartMode && count < smartModeLines) {
                            this.removeFooterComment(comment, rcurly);
                        }
                        ++count;
                        break;
                    }
                    default: {
                        int j = 0;
                        while (j < keys.length) {
                            if (comment.getText().indexOf(keys[j]) > -1) {
                                this.removeFooterComment(comment, rcurly);
                            }
                            ++j;
                        }
                        break block0;
                    }
                }
                comment = comment.getHiddenAfter();
            }
        }
    }

    private void removeFooterComment(CommonHiddenStreamToken comment, JavaNode node) {
        CommonHiddenStreamToken before = comment.getHiddenBefore();
        CommonHiddenStreamToken after = comment.getHiddenAfter();
        if (after != null) {
            after.setHiddenBefore(before);
            if (before != null) {
                before.setHiddenAfter(after);
            } else {
                node.setHiddenAfter(after);
            }
        } else if (before != null && comment != node.getHiddenAfter()) {
            before.setHiddenAfter(after);
            if (after != null) {
                after.setHiddenBefore(before);
            }
        } else {
            node.setHiddenAfter(null);
        }
        comment.setHiddenBefore(null);
    }

    private void removeHeader(AST node) {
        History.Policy historyPolicy = History.Policy.valueOf(settings.get(ConventionKeys.HISTORY_POLICY, ConventionDefaults.HISTORY_POLICY));
        JavaNode first = (JavaNode)node.getFirstChild();
        String[] keys = this.getConventionKeys(ConventionKeys.HEADER_KEYS);
        int smartModeLines = settings.getInt(ConventionKeys.HEADER_SMART_MODE_LINES, 0);
        boolean smartMode = smartModeLines > 0;
        int count = 0;
        CommonHiddenStreamToken token = first.getHiddenBefore();
        while (token != null) {
            if (token.getHiddenBefore() == null) {
                CommonHiddenStreamToken comment = token;
                while (comment != null && count <= smartModeLines) {
                    switch (comment.getType()) {
                        case 6: 
                        case 157: {
                            int j = 0;
                            while (j < keys.length) {
                                if (comment.getText().indexOf(keys[j]) > -1) {
                                    this.removeHeaderComment(comment, first);
                                }
                                ++j;
                            }
                            break;
                        }
                        case 155: {
                            if (comment.getText().indexOf(37) > -1) {
                                this.removeHeaderComment(comment, first);
                                break;
                            }
                            if (!smartMode || count >= smartModeLines) break;
                            this.removeHeaderComment(comment, first);
                        }
                    }
                    ++count;
                    comment = comment.getHiddenAfter();
                }
                break;
            }
            token = token.getHiddenBefore();
        }
    }

    private void removeHeaderComment(CommonHiddenStreamToken comment, JavaNode node) {
        CommonHiddenStreamToken before = comment.getHiddenBefore();
        CommonHiddenStreamToken after = comment.getHiddenAfter();
        if (after != null) {
            after.setHiddenBefore(before);
            if (before != null) {
                before.setHiddenAfter(after);
            }
        } else if (before != null) {
            before.setHiddenAfter(after);
            if (after != null) {
                after.setHiddenBefore(before);
            }
        } else if (comment == node.getHiddenBefore()) {
            node.setHiddenBefore(null);
        }
    }
}

