/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.io;

public final class FileFormat {
    public static final FileFormat DEFAULT = new FileFormat("DEFAULT", System.getProperty("line.separator"));
    public static final FileFormat AUTO = new FileFormat("AUTO", System.getProperty("line.separator"));
    public static final FileFormat DOS = new FileFormat("DOS", "\r\n");
    public static final FileFormat MAC = new FileFormat("MAC", "\r");
    public static final FileFormat UNIX = new FileFormat("UNIX", "\n");
    public static final FileFormat UNKNOWN = new FileFormat("UNKNOWN", System.getProperty("line.separator"));
    private final String _name;
    private final String _separator;

    private FileFormat(String name, String lineSeparator) {
        this._name = name.intern();
        this._separator = lineSeparator.intern();
    }

    public String getLineSeparator() {
        return this._separator;
    }

    public String getName() {
        return this._name;
    }

    public static FileFormat valueOf(String format) {
        String n = format.toUpperCase().intern();
        if (FileFormat.DOS._name == n || FileFormat.DOS._separator == n) {
            return DOS;
        }
        if (FileFormat.UNIX._name == n || FileFormat.UNIX._separator == n) {
            return UNIX;
        }
        if (FileFormat.MAC._name == n || FileFormat.MAC._separator == n) {
            return MAC;
        }
        if (FileFormat.AUTO._name == n) {
            return AUTO;
        }
        if (FileFormat.UNKNOWN._name == n) {
            return UNKNOWN;
        }
        return DEFAULT;
    }

    public String toString() {
        return this._separator;
    }
}

