/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.ser;

import com.mchange.v1.io.InputStreamUtils;
import com.mchange.v1.io.OutputStreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class SerializableUtils {
    private SerializableUtils() {
    }

    public static byte[] toByteArray(Object object) throws NotSerializableException {
        return SerializableUtils.serializeToByteArray(object);
    }

    public static byte[] serializeToByteArray(Object object) throws NotSerializableException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (NotSerializableException notSerializableException) {
            notSerializableException.fillInStackTrace();
            throw notSerializableException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("IOException writing to a byte array!");
        }
    }

    public static Object fromByteArray(byte[] byArray) throws IOException, ClassNotFoundException {
        return SerializableUtils.deserializeFromByteArray(byArray);
    }

    public static Object deserializeFromByteArray(byte[] byArray) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        return objectInputStream.readObject();
    }

    public static Object testSerializeDeserialize(Object object) throws IOException, ClassNotFoundException {
        byte[] byArray = SerializableUtils.serializeToByteArray(object);
        return SerializableUtils.deserializeFromByteArray(byArray);
    }

    public static final Object unmarshallObjectFromFile(File file) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            object = objectInputStream.readObject();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            InputStreamUtils.attemptClose(objectInputStream);
            throw throwable;
        }
        InputStreamUtils.attemptClose(objectInputStream);
        return object;
    }

    public static final void marshallObjectToFile(Object object, File file) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(object);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            OutputStreamUtils.attemptClose(objectOutputStream);
            throw throwable;
        }
        OutputStreamUtils.attemptClose(objectOutputStream);
    }
}

