/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.AbstractAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.CompositeAssertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyRegistry;

public class AndCompositeAssertion
extends AbstractAssertion
implements CompositeAssertion {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public void addTerm(Assertion assertion) {
        if (!this.isNormalized() || !(assertion instanceof PrimitiveAssertion)) {
            this.setNormalized(false);
        }
        super.addTerm(assertion);
    }

    public Assertion intersect(Assertion assertion, PolicyRegistry reg) {
        AndCompositeAssertion normalizedMe;
        this.log.debug((Object)"Enter: AndCompositeAssertion::intersect");
        Assertion assertion2 = normalizedMe = this.isNormalized() ? this : this.normalize(reg);
        if (!(normalizedMe instanceof AndCompositeAssertion)) {
            return normalizedMe.intersect(assertion, reg);
        }
        Assertion target = assertion.isNormalized() ? assertion : assertion.normalize(reg);
        short type = target.getType();
        switch (type) {
            case 4: {
                Policy nPOLICY = new Policy();
                nPOLICY.addTerm(normalizedMe.intersect((XorCompositeAssertion)target.getTerms().get(0)));
                return nPOLICY;
            }
            case 3: {
                XorCompositeAssertion nXOR = new XorCompositeAssertion();
                Iterator iterator = target.getTerms().iterator();
                while (iterator.hasNext()) {
                    Assertion asser = normalizedMe.intersect((AndCompositeAssertion)iterator.next());
                    if (2 != asser.getType()) continue;
                    nXOR.addTerm(asser);
                }
                return nXOR;
            }
            case 2: {
                List PRIMITIVES_A = normalizedMe.size() > target.size() ? normalizedMe.getTerms() : target.getTerms();
                List PRIMTIVES_B = normalizedMe.size() > target.size() ? target.getTerms() : normalizedMe.getTerms();
                boolean isMatch = true;
                PrimitiveAssertion PRIMTIVE_B = null;
                for (int i = 0; i < PRIMITIVES_A.size(); ++i) {
                    PrimitiveAssertion PRIMITIVE_A = (PrimitiveAssertion)PRIMITIVES_A.get(i);
                    boolean flag = false;
                    for (int j = 0; j < PRIMTIVES_B.size(); ++j) {
                        PRIMTIVE_B = (PrimitiveAssertion)PRIMTIVES_B.get(j);
                        if (!PRIMITIVE_A.getName().equals(PRIMTIVE_B.getName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        return new XorCompositeAssertion();
                    }
                    Assertion a = PRIMITIVE_A.intersect(PRIMTIVE_B);
                    if (!(a instanceof XorCompositeAssertion)) continue;
                    return new XorCompositeAssertion();
                }
                AndCompositeAssertion result = new AndCompositeAssertion();
                result.addTerms(PRIMITIVES_A);
                result.addTerms(PRIMTIVES_B);
                return result;
            }
            case 1: {
                QName name = ((PrimitiveAssertion)target).getName();
                boolean isMatch = false;
                Iterator iterator = normalizedMe.getTerms().iterator();
                while (iterator.hasNext()) {
                    QName targetName = ((PrimitiveAssertion)iterator.next()).getName();
                    if (!name.getNamespaceURI().equals(targetName.getNamespaceURI())) continue;
                    isMatch = true;
                    break;
                }
                if (isMatch) {
                    AndCompositeAssertion nAND = new AndCompositeAssertion();
                    nAND.addTerms(normalizedMe.getTerms());
                    nAND.addTerm(target);
                    return nAND;
                }
                return new XorCompositeAssertion();
            }
        }
        throw new IllegalArgumentException("intersect is not defined for " + target.getClass().getName() + "type assertions");
    }

    public Assertion merge(Assertion assertion, PolicyRegistry reg) {
        AndCompositeAssertion normalizedMe;
        this.log.debug((Object)"Enter: AndCompositeAssertion::merge");
        Assertion assertion2 = normalizedMe = this.isNormalized() ? this : this.normalize(reg);
        if (!(normalizedMe instanceof AndCompositeAssertion)) {
            return normalizedMe.merge(assertion, reg);
        }
        Assertion target = assertion.isNormalized() ? assertion : assertion.normalize(reg);
        switch (target.getType()) {
            case 4: {
                Policy nPOLICY = new Policy();
                nPOLICY.addTerm(normalizedMe.merge((XorCompositeAssertion)target.getTerms().get(0)));
                return nPOLICY;
            }
            case 3: {
                XorCompositeAssertion nXOR = new XorCompositeAssertion();
                for (AndCompositeAssertion AND : target.getTerms()) {
                    nXOR.addTerm(normalizedMe.merge(AND));
                }
                return nXOR;
            }
            case 2: {
                AndCompositeAssertion nAND = new AndCompositeAssertion();
                nAND.addTerms(normalizedMe.getTerms());
                nAND.addTerms(target.getTerms());
                return nAND;
            }
            case 1: {
                AndCompositeAssertion nAND = new AndCompositeAssertion();
                nAND.addTerms(normalizedMe.getTerms());
                nAND.addTerm(target);
                return nAND;
            }
        }
        throw new IllegalArgumentException("merge is not defined for");
    }

    public Assertion normalize(PolicyRegistry reg) {
        this.log.debug((Object)"Enter: AndCompositeAssertion::normalize");
        if (this.isNormalized()) {
            return this;
        }
        AndCompositeAssertion AND = new AndCompositeAssertion();
        XorCompositeAssertion XOR = new XorCompositeAssertion();
        ArrayList<Assertion> XORs = new ArrayList<Assertion>();
        if (this.isEmpty()) {
            AND.setNormalized(true);
            return AND;
        }
        for (Assertion term : this.getTerms()) {
            Assertion assertion = term = term instanceof Policy ? term : term.normalize(reg);
            if (term instanceof Policy) {
                AndCompositeAssertion wrapper = new AndCompositeAssertion();
                wrapper.addTerms(((Policy)term).getTerms());
                term = wrapper.normalize(reg);
            }
            if (term instanceof XorCompositeAssertion) {
                if (((XorCompositeAssertion)term).isEmpty()) {
                    XorCompositeAssertion anXOR = new XorCompositeAssertion();
                    anXOR.setNormalized(true);
                    return anXOR;
                }
                XORs.add(term);
                continue;
            }
            if (term instanceof AndCompositeAssertion) {
                AND.addTerms(((AndCompositeAssertion)term).getTerms());
                continue;
            }
            AND.addTerm(term);
        }
        if (XORs.size() > 1) {
            for (int i = 0; i < XORs.size(); ++i) {
                for (int j = i; j < XORs.size(); ++j) {
                    if (i == j) continue;
                    XorCompositeAssertion XOR_A = (XorCompositeAssertion)XORs.get(i);
                    XorCompositeAssertion XOR_B = (XorCompositeAssertion)XORs.get(j);
                    for (Assertion anAND_A : XOR_A.getTerms()) {
                        for (Assertion anAND_B : XOR_B.getTerms()) {
                            AndCompositeAssertion nAND = new AndCompositeAssertion();
                            nAND.addTerms(anAND_A.getTerms());
                            nAND.addTerms(anAND_B.getTerms());
                            XOR.addTerm(nAND);
                        }
                    }
                }
            }
        } else if (XORs.size() == 1) {
            Assertion XORterm = (Assertion)XORs.get(0);
            XOR.addTerms(XORterm.getTerms());
        }
        if (XOR.isEmpty()) {
            AND.setNormalized(true);
            return AND;
        }
        if (AND.isEmpty()) {
            XOR.setNormalized(true);
            return XOR;
        }
        List primTerms = AND.getTerms();
        for (Assertion rAND : XOR.getTerms()) {
            rAND.addTerms(primTerms);
        }
        XOR.setNormalized(true);
        return XOR;
    }

    public final short getType() {
        return 2;
    }
}

