/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.NamingException;
import org.jboss.annotation.JndiInject;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.injection.pojo.InjectionHelper;
import org.jboss.ejb3.injection.pojo.PojoInjector;

public class JndiInjector
implements PojoInjector {
    private Hashtable initialContextProperties;

    public JndiInjector(Hashtable initialContextProperties) {
        this.initialContextProperties = initialContextProperties;
    }

    public void inject(Method m, Annotation annotation, Object pojo) {
        InjectionHelper.checkMethodSignature(m, annotation);
        JndiInject ref = (JndiInject)annotation;
        Object obj = null;
        obj = this.getResource(m.getParameterTypes()[0], m.getName().substring(3), ref);
        try {
            m.invoke(pojo, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object getResource(Class type, String defaultEncName, JndiInject ref) {
        Object obj;
        String jndiName = ref.jndiName();
        if (jndiName == null || jndiName.equals("")) {
            jndiName = defaultEncName;
        }
        try {
            obj = EJB3Util.getInitialContext(this.initialContextProperties).lookup(jndiName);
        }
        catch (NamingException e) {
            jndiName = "java:/" + jndiName;
            try {
                obj = EJB3Util.getInitialContext(this.initialContextProperties).lookup(jndiName);
            }
            catch (NamingException e1) {
                throw new RuntimeException(e1);
            }
        }
        return obj;
    }

    public void inject(Field f, Annotation annotation, Object pojo) {
        JndiInject ref = (JndiInject)annotation;
        Object obj = this.getResource(f.getType(), f.getName(), ref);
        try {
            f.setAccessible(true);
            f.set(pojo, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

