/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.EJB;
import javax.annotation.Resource;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.jboss.annotation.JndiInject;
import org.jboss.annotation.ejb.Depends;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.injection.pojo.DependsInjector;
import org.jboss.ejb3.injection.pojo.EJBInjector;
import org.jboss.ejb3.injection.pojo.JndiInjector;
import org.jboss.ejb3.injection.pojo.PersistenceContextInjector;
import org.jboss.ejb3.injection.pojo.PersistenceUnitInjector;
import org.jboss.ejb3.injection.pojo.PojoInjector;
import org.jboss.ejb3.injection.pojo.ResourceInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionHelper {
    public static void inject(Object target, Class clazz, Class<? extends Annotation> annotation, PojoInjector injector) {
        Field[] fields;
        Method[] methods;
        if (clazz.equals(Object.class)) {
            return;
        }
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            injector.inject(m, m.getAnnotation(annotation), target);
        }
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(annotation)) continue;
            injector.inject(f, f.getAnnotation(annotation), target);
        }
        InjectionHelper.inject(target, clazz.getSuperclass(), annotation, injector);
    }

    public static void checkMethodSignature(Method m, Annotation a) {
        if (!m.getName().startsWith("set")) {
            throw new RuntimeException("@" + a.getClass().getName() + " can only be used with a set method: " + m);
        }
        if (m.getParameterTypes().length != 1) {
            throw new RuntimeException("@" + a.getClass().getName() + " can only be used with a set method of one parameter: " + m);
        }
    }

    public static void iterateHardcodedInjectors(Container container, Object target, BeanContext ctx) {
        DependsInjector depends = new DependsInjector();
        EJBInjector ejb = new EJBInjector(container.getEjbLinkResolver(), container.getInitialContext());
        JndiInjector jndi = new JndiInjector(container.getInitialContextProperties());
        PersistenceContextInjector pc = new PersistenceContextInjector(container.getInitialContextProperties());
        PersistenceUnitInjector pu = new PersistenceUnitInjector(container.getInitialContextProperties());
        ResourceInjector resource = new ResourceInjector(container, ctx);
        InjectionHelper.inject(target, target.getClass(), Depends.class, depends);
        InjectionHelper.inject(target, target.getClass(), EJB.class, ejb);
        InjectionHelper.inject(target, target.getClass(), JndiInject.class, jndi);
        InjectionHelper.inject(target, target.getClass(), PersistenceContext.class, pc);
        InjectionHelper.inject(target, target.getClass(), PersistenceUnit.class, pu);
        InjectionHelper.inject(target, target.getClass(), Resource.class, resource);
    }
}

