/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.entity.HibernateSession;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectedEntityManager
implements EntityManager,
HibernateSession,
Serializable {
    private transient ManagedEntityManagerFactory factory;
    private String jndiName;
    private Hashtable initialContextProperties;

    @Override
    public Session getHibernateSession() {
        if (this.getSession() instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)this.getSession()).getSession();
        }
        throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
    }

    public InjectedEntityManager(ManagedEntityManagerFactory factory, Hashtable initialContextProperties) {
        if (factory == null) {
            throw new NullPointerException("factory must not be null");
        }
        this.factory = factory;
        this.jndiName = factory.getJndiName();
        this.initialContextProperties = initialContextProperties;
    }

    public InjectedEntityManager() {
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.getSession().getReference(entityClass, primaryKey);
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getSession().setFlushMode(flushMode);
    }

    public Query createQuery(String ejbqlString) {
        return this.getSession().createQuery(ejbqlString);
    }

    public Query createNamedQuery(String name) {
        return this.getSession().createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString) {
        return this.getSession().createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.getSession().createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.getSession().createNativeQuery(sqlString, resultSetMapping);
    }

    public <A> A find(Class<A> entityClass, Object primaryKey) {
        return (A)this.getSession().find(entityClass, primaryKey);
    }

    public void persist(Object entity) {
        this.getSession().persist(entity);
    }

    public <A> A merge(A entity) {
        return (A)this.getSession().merge(entity);
    }

    public void remove(Object entity) {
        this.getSession().remove(entity);
    }

    public void refresh(Object entity) {
        this.getSession().refresh(entity);
    }

    public boolean contains(Object entity) {
        return this.getSession().contains(entity);
    }

    public void flush() {
        this.getSession().flush();
    }

    public void close() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    public boolean isOpen() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    protected EntityManager getSession() {
        if (this.factory == null) {
            try {
                InitialContext ctx = EJB3Util.getInitialContext(this.initialContextProperties);
                this.factory = (ManagedEntityManagerFactory)ctx.lookup(this.jndiName);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.factory.getSession();
    }
}

