/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.HashMap;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.entity.ExtendedPersistenceContext;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;

public class ExtendedPersistenceContextPropagationInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(ExtendedPersistenceContextPropagationInterceptor.class);

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        log.debug((Object)"++++ LongLivedSessionPropagationInterceptor");
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
        HashMap extendedPCs = ctx.getMetaData().tag("LONG_LIVED_SESSION");
        if (extendedPCs == null) {
            return invocation.invokeNext();
        }
        HashMap<String, ExtendedPersistenceContext> pcMap = new HashMap<String, ExtendedPersistenceContext>();
        for (String name : extendedPCs.keySet()) {
            ExtendedPersistenceContext pc = (ExtendedPersistenceContext)ctx.getMetaData().getMetaData((Object)"LONG_LIVED_SESSION", (Object)name);
            pcMap.put(name, pc);
        }
        Object old = ManagedEntityManagerFactory.longLivedSession.get();
        try {
            ManagedEntityManagerFactory.longLivedSession.set(pcMap);
            TransactionManager tm = TxUtil.getTransactionManager();
            if (tm.getTransaction() != null) {
                for (ExtendedPersistenceContext pc : pcMap.values()) {
                    pc.getFactory().registerPersistenceContext();
                }
            }
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            ManagedEntityManagerFactory.longLivedSession.set(old);
        }
    }
}

