/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import javax.ejb.PostConstruct;
import javax.ejb.PreDestroy;
import javax.ejb.Timeout;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.EJBProxyFactory;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.EjbLinkResolver;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.ejb3.dd.EnterpriseBean;
import org.jboss.ejb3.injection.DependsHandler;
import org.jboss.ejb3.injection.EJBHandler;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.JndiInjectHandler;
import org.jboss.ejb3.injection.PersistenceContextHandler;
import org.jboss.ejb3.injection.PersistenceUnitHandler;
import org.jboss.ejb3.injection.ResourceHandler;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.ejb3.interceptor.LifecycleInterceptorHandler;
import org.jboss.ejb3.tx.UserTransactionImpl;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EJBContainer
extends ClassContainer
implements Container {
    private static final Logger log = Logger.getLogger(EJBContainer.class);
    protected Pool pool;
    protected String ejbName;
    protected ObjectName objectName;
    protected int defaultConstructorIndex;
    protected String beanClassName;
    protected ClassLoader classloader;
    protected Injector[] injectors;
    protected Context enc;
    protected Context encEnv;
    protected Class beanContextClass;
    protected LifecycleInterceptorHandler callbackHandler;
    protected EjbLinkResolver ejbLinkResolver;
    protected Hashtable initialContextProperties;
    protected HashMap envEntries = new HashMap();
    protected HashMap<String, String> encEntries = new HashMap();
    protected EnterpriseBean xml;
    protected HashMap<AccessibleObject, Injector> encInjections = new HashMap();
    protected EJBProxyFactory proxyFactory;
    protected InterceptorInfoRepository interceptorRepository;
    protected List<InterceptorInfo> classInterceptors = new ArrayList<InterceptorInfo>();
    protected LinkedHashSet<InterceptorInfo> applicableInterceptors;
    private HashMap<Class, InterceptorInjector> interceptorInjectors;
    private Ejb3Deployment deployment;
    private DependencyPolicy dependencyPolicy;
    public static final String MANAGED_ENTITY_MANAGER_FACTORY = "ManagedEntityManagerFactory";
    public static final String ENTITY_MANAGER_FACTORY = "EntityManagerFactory";

    public EJBContainer(String name, AspectManager manager, ClassLoader cl, String beanClassName, String ejbName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository) {
        super(name, manager);
        this.beanClassName = beanClassName;
        this.classloader = cl;
        try {
            this.clazz = this.classloader.loadClass(beanClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.ejbName = ejbName;
        String on = "jboss.j2ee:service=EJB3,name=" + ejbName;
        try {
            this.objectName = new ObjectName(on);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        this.initialContextProperties = ctxProperties;
        InitialContext ctx = this.getInitialContext();
        try {
            this.enc = ThreadLocalENCFactory.create(ctx);
            this.encEnv = Util.createSubcontext((Context)this.enc, (String)"env");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.interceptorRepository = interceptorRepository;
        this.interceptorRepository.addBeanClass(this.clazz.getName());
    }

    public Ejb3Deployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(Ejb3Deployment deployment) {
        this.deployment = deployment;
    }

    public DependencyPolicy getDependencyPolicy() {
        return this.dependencyPolicy;
    }

    @Override
    public void setDependencyPolicy(DependencyPolicy dependencyPolicy) {
        this.dependencyPolicy = dependencyPolicy;
        PersistenceContextHandler.loadDependencies(this, this.clazz, true);
        PersistenceUnitHandler.loadDependencies(this, this.clazz, true);
        if (this.xml != null) {
            for (String depends : this.xml.getDependencies()) {
                dependencyPolicy.addDependency(depends);
            }
        }
        DependsHandler.loadDependencies(this);
    }

    public EJBProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public void setProxyFactory(EJBProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public EnterpriseBean getXml() {
        return this.xml;
    }

    public void setXml(EnterpriseBean xml) {
        this.xml = xml;
    }

    public InterceptorInfoRepository getInterceptorRepository() {
        return this.interceptorRepository;
    }

    public List<InterceptorInfo> getClassInterceptors() {
        this.initialiseInterceptors();
        return this.classInterceptors;
    }

    public HashSet<InterceptorInfo> getApplicableInterceptors() {
        this.initialiseInterceptors();
        return this.applicableInterceptors;
    }

    public HashMap<Class, InterceptorInjector> getInterceptorInjectors() {
        this.initialiseInterceptors();
        return this.interceptorInjectors;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public HashMap<String, String> getEncEntries() {
        return this.encEntries;
    }

    @Override
    public void addEncEntry(String name, String mappedName) {
        this.encEntries.put(name, mappedName);
    }

    public void addEncInjector(AccessibleObject acc, Injector inj) {
        this.encInjections.put(acc, inj);
    }

    @Override
    public InitialContext getInitialContext() {
        try {
            if (this.initialContextProperties == null) {
                return new InitialContext();
            }
            return new InitialContext(this.initialContextProperties);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public HashMap<AccessibleObject, Injector> getEncInjections() {
        return this.encInjections;
    }

    public boolean hasEnvEntry(String name) {
        return this.envEntries.containsKey(name);
    }

    public void addEnvEntry(String name, String type, String value) throws ClassNotFoundException {
        this.envEntries.put(name, this.getEnvEntryValue(name, type, value));
    }

    public boolean hasEncEntry(String name) {
        return this.encEntries.containsKey(name);
    }

    @Override
    public Context getEnc() {
        return this.enc;
    }

    public Context getEncEnv() {
        return this.enc;
    }

    protected Object getEnvEntryValue(String name, String entryType, String value) throws ClassNotFoundException {
        Class<?> type = this.classloader.loadClass(entryType);
        if (type == String.class) {
            return value;
        }
        if (type == Integer.class) {
            return new Integer(value);
        }
        if (type == Long.class) {
            return new Long(value);
        }
        if (type == Double.class) {
            return new Double(value);
        }
        if (type == Float.class) {
            return new Float(value);
        }
        if (type == Byte.class) {
            return new Byte(value);
        }
        if (type == Character.class) {
            String input = value;
            if (input == null || input.length() == 0) {
                return new Character('\u0000');
            }
            if (input.length() > 1) {
                log.warn((Object)("Warning character env-entry is too long: binding=" + name + " value=" + input));
            }
            return new Character(input.charAt(0));
        }
        if (type == Short.class) {
            return new Short(value);
        }
        if (type == Boolean.class) {
            return new Boolean(value);
        }
        return value;
    }

    @Override
    public Hashtable getInitialContextProperties() {
        return this.initialContextProperties;
    }

    @Override
    public EjbLinkResolver getEjbLinkResolver() {
        return this.ejbLinkResolver;
    }

    @Override
    public void setEjbLinkResolver(EjbLinkResolver ejbLinkResolver) {
        this.ejbLinkResolver = ejbLinkResolver;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getEjbName() {
        return this.ejbName;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    @Override
    public Class getBeanClass() {
        return this.clazz;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public Object construct() {
        Interceptor[] cInterceptors = this.constructorInterceptors[this.defaultConstructorIndex];
        if (cInterceptors == null) {
            try {
                return this.constructors[this.defaultConstructorIndex].newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        ConstructorInvocation invocation = new ConstructorInvocation(cInterceptors);
        invocation.setAdvisor((Advisor)this);
        invocation.setConstructor(this.constructors[this.defaultConstructorIndex]);
        try {
            return invocation.invokeNext();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public void create() throws Exception {
        this.initializeClassContainer();
        for (int i = 0; i < this.constructors.length; ++i) {
            if (this.constructors[i].getParameterTypes().length != 0) continue;
            this.defaultConstructorIndex = i;
            break;
        }
        this.createEnvEntries();
        this.initializePool();
        this.resolveInterceptorInjectors();
        this.createCallbackHandler();
        for (String encName : this.encEntries.keySet()) {
            String mappedName = this.encEntries.get(encName);
            Util.bind((Context)this.enc, (String)encName, (Object)new LinkRef(mappedName));
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public void destroy() throws Exception {
    }

    protected void createEnvEntries() throws NamingException {
        for (String name : this.envEntries.keySet()) {
            Object value = this.envEntries.get(name);
            Util.bind((Context)this.encEnv, (String)name, value);
        }
    }

    public void initializePool() throws Exception {
        PoolClass poolClass = (PoolClass)this.resolveAnnotation(PoolClass.class);
        Class poolClazz = poolClass.value();
        int maxSize = poolClass.maxSize();
        long timeout = poolClass.timeout();
        this.pool = (Pool)poolClazz.newInstance();
        this.pool.initialize(this, this.beanContextClass, this.clazz, maxSize, timeout);
        this.resolveInjectors();
        this.pool.setInjectors(this.injectors);
    }

    @Override
    public void invokePostConstruct(BeanContext beanContext) {
        this.callbackHandler.postConstruct(beanContext);
    }

    @Override
    public void invokePreDestroy(BeanContext beanContext) {
        this.callbackHandler.preDestroy(beanContext);
    }

    @Override
    public void invokePostActivate(BeanContext beanContext) {
        throw new RuntimeException("PostActivate not implemented for container");
    }

    @Override
    public void invokePrePassivate(BeanContext beanContext) {
        throw new RuntimeException("PostActivate not implemented for container");
    }

    @Override
    public void invokeInit(Object bean) {
    }

    @Override
    public void invokeInit(Object bean, Class[] initParameterTypes, Object[] initParameterValues) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveInjectors() throws Exception {
        ThreadLocalENCFactory.push(this.enc);
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            Util.bind((Context)this.enc, (String)"UserTransaction", (Object)new UserTransactionImpl());
            ArrayList<Injector> list = new ArrayList<Injector>();
            list.addAll(JndiInjectHandler.loadInjectors(this));
            ResourceHandler.loadInjectors(this);
            EJBHandler.loadInjectors(this);
            list.addAll(DependsHandler.loadInjectors(this));
            list.addAll(PersistenceContextHandler.loadInjectors(this));
            list.addAll(PersistenceUnitHandler.loadInjectors(this));
            list.addAll(this.encInjections.values());
            this.injectors = list.toArray(new Injector[list.size()]);
        }
        finally {
            ThreadLocalENCFactory.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveInterceptorInjectors() throws Exception {
        ThreadLocalENCFactory.push(this.enc);
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            if (this.applicableInterceptors != null && this.applicableInterceptors.size() > 0) {
                this.interceptorInjectors = new HashMap();
                for (InterceptorInfo interceptorInfo : this.applicableInterceptors) {
                    InterceptorInjector injector = new InterceptorInjector(this, interceptorInfo);
                    this.interceptorInjectors.put(interceptorInfo.getClazz(), injector);
                }
            }
        }
        finally {
            ThreadLocalENCFactory.pop();
        }
    }

    protected void createCallbackHandler() {
        try {
            this.callbackHandler = new LifecycleInterceptorHandler(this, this.getHandledCallbacks());
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating callback handler for bean " + this.beanClassName, e);
        }
    }

    protected Class[] getHandledCallbacks() {
        return new Class[]{PostConstruct.class, PreDestroy.class, Timeout.class};
    }

    private void initialiseInterceptors() {
        if (this.applicableInterceptors == null) {
            log.info((Object)("Initialising interceptors for " + this.getEjbName() + "..."));
            HashSet<InterceptorInfo> defaultInterceptors = this.interceptorRepository.getDefaultInterceptors();
            log.info((Object)("Default interceptors: " + defaultInterceptors));
            this.classInterceptors = this.interceptorRepository.getClassInterceptors(this);
            log.info((Object)("Class interceptors: " + this.classInterceptors));
            this.applicableInterceptors = new LinkedHashSet();
            if (defaultInterceptors != null) {
                this.applicableInterceptors.addAll(defaultInterceptors);
            }
            if (this.classInterceptors != null) {
                this.applicableInterceptors.addAll(this.classInterceptors);
            }
            Method[] methods = this.clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                ArrayList<InterceptorInfo> methodIcptrs = this.interceptorRepository.getMethodInterceptors(this, methods[i]);
                if (methodIcptrs == null || methodIcptrs.size() <= 0) continue;
                log.info((Object)("Method interceptors for  " + methods[i] + ": " + methodIcptrs));
                this.applicableInterceptors.addAll(methodIcptrs);
            }
            log.info((Object)("All applicable interceptor classes: " + this.applicableInterceptors));
        }
    }
}

