/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.utils.XATxConverter;
import com.arjuna.ats.internal.jta.Implementations;
import com.arjuna.ats.internal.jta.recovery.arjunacore.RecoveryXids;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryResourceManagerImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.AtomicAction;
import com.arjuna.ats.internal.jta.utils.XAUtils;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XAConnectionRecovery;
import com.arjuna.ats.jta.recovery.XARecoveryResource;
import com.arjuna.ats.jta.recovery.XARecoveryResourceManager;
import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XARecoveryModule
implements RecoveryModule {
    public static final String XARecoveryPropertyNamePrefixOld = "XAConnectionRecovery";
    public static final String XARecoveryPropertyNamePrefix = "com.arjuna.ats.jta.recovery.XAResourceRecovery";
    private static final String RECOVER_ALL_NODES = "*";
    private ObjectStore _objStore = new ObjectStore();
    private InputObjectState _uids = new InputObjectState();
    private Vector _xaRecoverers = null;
    private Hashtable _failures = null;
    private Vector _xaRecoveryNodes = null;
    private Hashtable _xidScans = null;
    private XARecoveryResourceManager _recoveryManagerClass = null;
    private String _logName = null;
    private String _transactionType = new AtomicAction().type();
    private static ObjectStore _transactionStore = null;
    private static int _backoffPeriod = 0;
    private static final int XA_BACKOFF_PERIOD = 20000;
    private static final char BREAKCHARACTER = ';';

    public XARecoveryModule() {
        this(XARecoveryResourceManagerImple.class.getName(), "Local XARecoveryModule");
        Implementations.initialise();
    }

    public void periodicWorkFirstPass() {
        block6: {
            if (jtaLogger.loggerI18N.isInfoEnabled()) {
                jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.firstpass", new Object[]{this._logName});
            }
            this._uids = new InputObjectState();
            try {
                if (!this._objStore.allObjUids(this._recoveryManagerClass.type(), this._uids) && jtaLogger.loggerI18N.isWarnEnabled()) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.alluids");
                }
            }
            catch (ObjectStoreException e) {
                if (jtaLogger.loggerI18N.isWarnEnabled()) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.objstoreerror", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!jtaLogger.loggerI18N.isWarnEnabled()) break block6;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.periodicfirstpass", new Object[]{this._logName + ".periodicWorkFirstPass exception "}, (Throwable)e);
            }
        }
    }

    public void periodicWorkSecondPass() {
        block5: {
            if (jtaLogger.logger.isInfoEnabled() && jtaLogger.loggerI18N.isInfoEnabled()) {
                jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.secondpass", new Object[]{this._logName});
            }
            try {
                this.transactionInitiatedRecovery();
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug(16L, 4L, 2048L, this._logName + ".transactionInitiatedRecovery completed");
                }
                this.resourceInitiatedRecovery();
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug(16L, 4L, 2048L, this._logName + ".resourceInitiatedRecovery completed");
                }
            }
            catch (Exception e) {
                if (!jtaLogger.loggerI18N.isWarnEnabled()) break block5;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.periodicsecondpass", new Object[]{this._logName + ".periodicWorkSecondPass exception "}, (Throwable)e);
            }
        }
        this.clearAllFailures();
    }

    public String id() {
        return "XARecoveryModule:" + this._recoveryManagerClass;
    }

    public XAResource getNewXAResource(Xid xid) {
        if (this._xidScans != null) {
            Enumeration keys = this._xidScans.keys();
            while (keys.hasMoreElements()) {
                XAResource theKey = (XAResource)keys.nextElement();
                RecoveryXids xids = (RecoveryXids)this._xidScans.get(theKey);
                if (!xids.contains(xid)) continue;
                return theKey;
            }
        }
        return null;
    }

    protected XARecoveryModule(String recoveryClass, String logName) {
        this._xaRecoverers = new Vector();
        this._logName = logName;
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(recoveryClass);
            this._recoveryManagerClass = (XARecoveryResourceManager)c.newInstance();
        }
        catch (Exception ex) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.constfail", (Throwable)ex);
            }
            this._recoveryManagerClass = null;
        }
        Properties props = jtaPropertyManager.propertyManager.getProperties();
        if (props != null) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String propName = (String)names.nextElement();
                if (propName.startsWith(XARecoveryPropertyNamePrefix) || propName.startsWith(XARecoveryPropertyNamePrefixOld)) {
                    String theClassAndParameter = jtaPropertyManager.propertyManager.getProperty(propName);
                    int breakPosition = theClassAndParameter.indexOf(59);
                    String theClass = null;
                    String theParameter = null;
                    if (breakPosition != -1) {
                        theClass = theClassAndParameter.substring(0, breakPosition);
                        theParameter = theClassAndParameter.substring(breakPosition + 1);
                    } else {
                        theClass = theClassAndParameter;
                    }
                    if (jtaLogger.loggerI18N.isInfoEnabled() && jtaLogger.loggerI18N.isInfoEnabled()) {
                        jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.loading", new Object[]{this._logName, theClass + (theParameter != null ? theParameter : "")});
                    }
                    if (theClass == null) {
                        if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.classloadfail", new Object[]{this._logName, propName});
                        continue;
                    }
                    try {
                        Object ri;
                        Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(theClass);
                        boolean newInterface = false;
                        try {
                            ri = (XAConnectionRecovery)c.newInstance();
                            if (theParameter != null) {
                                ri.initialise(theParameter);
                            }
                            this._xaRecoverers.addElement(ri);
                        }
                        catch (ClassCastException ex) {
                            newInterface = true;
                        }
                        if (!newInterface) continue;
                        ri = (XAResourceRecovery)c.newInstance();
                        if (theParameter != null) {
                            ri.initialise(theParameter);
                        }
                        this._xaRecoverers.addElement(ri);
                    }
                    catch (Exception e) {
                        if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.general", new Object[]{e, theClass});
                    }
                    continue;
                }
                if (!propName.startsWith("com.arjuna.ats.jta.xaRecoveryNode")) continue;
                String name = jtaPropertyManager.propertyManager.getProperty(propName);
                if (this._xaRecoveryNodes == null) {
                    this._xaRecoveryNodes = new Vector();
                }
                this._xaRecoveryNodes.addElement(name);
            }
        }
        if ((this._xaRecoveryNodes == null || this._xaRecoveryNodes.size() == 0) && jtaLogger.loggerI18N.isInfoEnabled()) {
            jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.noxanodes");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean transactionInitiatedRecovery() {
        Uid theUid = new Uid();
        while (theUid.notEquals(Uid.nullUid())) {
            try {
                XARecoveryResource record;
                boolean problem;
                block16: {
                    theUid.unpack(this._uids);
                    if (!theUid.notEquals(Uid.nullUid()) || this._objStore.currentState(theUid, this._recoveryManagerClass.type()) == 0) continue;
                    problem = false;
                    record = null;
                    try {
                        record = this._recoveryManagerClass.getResource(theUid);
                        problem = true;
                        switch (record.recoverable()) {
                            case 12: {
                                int recoveryStatus;
                                if (jtaLogger.logger.isDebugEnabled()) {
                                    jtaLogger.logger.debug(16L, 4L, 2048L, "XARecovery attempting recovery of " + theUid);
                                }
                                if ((recoveryStatus = record.recover()) != 1) {
                                    if (recoveryStatus == 3) {
                                        problem = false;
                                        if (!jtaLogger.loggerI18N.isInfoEnabled()) break;
                                        jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.recoverydelayed", new Object[]{theUid, new Integer(recoveryStatus)});
                                        break;
                                    }
                                    if (!jtaLogger.loggerI18N.isWarnEnabled()) break;
                                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.recoveryfailed", new Object[]{theUid, new Integer(recoveryStatus)});
                                    break;
                                }
                                problem = false;
                                break;
                            }
                            case 11: {
                                problem = false;
                                break;
                            }
                            default: {
                                if (!jtaLogger.logger.isDebugEnabled()) break;
                                jtaLogger.logger.debug(16L, 4L, 2048L, "XARecovery " + theUid + " is non-recoverable");
                                break;
                            }
                        }
                    }
                    catch (NullPointerException ex) {
                        problem = true;
                    }
                    catch (Throwable e) {
                        problem = true;
                        if (!jtaLogger.loggerI18N.isWarnEnabled()) break block16;
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.recoveryerror", e);
                    }
                }
                if (!problem || record == null) continue;
                if (record.getXid() == null) {
                    if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.cannotadd");
                    continue;
                }
                this.addFailure(record.getXid(), record.get_uid());
            }
            catch (IOException e) {
                theUid = Uid.nullUid();
            }
            catch (Throwable e) {
                if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.unexpectedrecoveryerror", e);
                continue;
            }
            break;
        }
        return true;
    }

    private final boolean resourceInitiatedRecovery() {
        if (this._xaRecoverers.size() > 0) {
            for (int i = 0; i < this._xaRecoverers.size(); ++i) {
                Object ri;
                XAResource resource = null;
                if (this._xaRecoverers.elementAt(i) instanceof XAConnectionRecovery) {
                    try {
                        ri = (XAConnectionRecovery)this._xaRecoverers.elementAt(i);
                        while (ri.hasMoreConnections()) {
                            try {
                                resource = ri.getConnection().getXAResource();
                                this.xaRecovery(resource);
                            }
                            catch (Exception exp) {
                                if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", (Throwable)exp);
                            }
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", (Throwable)ex);
                        continue;
                    }
                }
                try {
                    ri = (XAResourceRecovery)this._xaRecoverers.elementAt(i);
                    while (ri.hasMoreResources()) {
                        try {
                            resource = ri.getXAResource();
                            this.xaRecovery(resource);
                        }
                        catch (Exception exp) {
                            if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", (Throwable)exp);
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    if (!jtaLogger.loggerI18N.isWarnEnabled()) continue;
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", (Throwable)ex);
                }
            }
        }
        return true;
    }

    private final boolean xaRecovery(XAResource xares) {
        block58: {
            block55: {
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug(16L, 4L, 2048L, "xarecovery of " + xares);
                }
                try {
                    Xid[] trans = null;
                    try {
                        trans = xares.recover(0x1000000);
                        if (jtaLogger.loggerI18N.isDebugEnabled()) {
                            jtaLogger.logger.debug(16L, 4L, 2048L, "Found " + (trans != null ? trans.length : 0) + " xids in doubt");
                        }
                    }
                    catch (XAException e) {
                        if (jtaLogger.loggerI18N.isWarnEnabled()) {
                            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.xarecovery1", new Object[]{this._logName + ".xaRecovery ", e, XAHelper.printXAErrorCode(e)});
                        }
                        try {
                            xares.recover(0x800000);
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                        return false;
                    }
                    RecoveryXids xidsToRecover = null;
                    if (this._xidScans == null) {
                        this._xidScans = new Hashtable();
                    } else {
                        xidsToRecover = (RecoveryXids)this._xidScans.get(xares);
                        if (xidsToRecover == null) {
                            Enumeration elements = this._xidScans.elements();
                            boolean found = false;
                            while (elements.hasMoreElements()) {
                                xidsToRecover = (RecoveryXids)elements.nextElement();
                                if (!xidsToRecover.isSameRM(xares)) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                xidsToRecover = null;
                            }
                        }
                    }
                    if (xidsToRecover == null) {
                        xidsToRecover = new RecoveryXids(xares);
                        this._xidScans.put(xares, xidsToRecover);
                    }
                    xidsToRecover.nextScan(trans);
                    Object[] xids = xidsToRecover.toRecover();
                    if (xids == null) break block55;
                    if (jtaLogger.loggerI18N.isDebugEnabled()) {
                        jtaLogger.logger.debug(16L, 4L, 2048L, "Have " + xids.length + " Xids to recover on this pass.");
                    }
                    for (int j = 0; j < xids.length; ++j) {
                        boolean doForget = false;
                        Uid recordUid = null;
                        boolean foundTransaction = false;
                        while ((recordUid = this.previousFailure((Xid)xids[j])) != null || !foundTransaction) {
                            block57: {
                                block56: {
                                    if (recordUid == null) {
                                        if (jtaLogger.loggerI18N.isDebugEnabled()) {
                                            jtaLogger.logger.debug(16L, 4L, 2048L, "Checking node name of " + (Xid)xids[j]);
                                        }
                                        String nodeName = XAUtils.getXANodeName((Xid)xids[j]);
                                        boolean doRecovery = false;
                                        if (jtaLogger.loggerI18N.isDebugEnabled()) {
                                            jtaLogger.logger.debug(16L, 4L, 2048L, "Node name is " + nodeName);
                                        }
                                        if (nodeName == null && this._xaRecoveryNodes != null && this._xaRecoveryNodes.contains(RECOVER_ALL_NODES)) {
                                            if (jtaLogger.loggerI18N.isDebugEnabled()) {
                                                jtaLogger.logger.debug(16L, 4L, 2048L, "Will recover this Xid (a)");
                                            }
                                            doRecovery = true;
                                        } else if (nodeName != null) {
                                            if (this._xaRecoveryNodes != null) {
                                                if (this._xaRecoveryNodes.contains(RECOVER_ALL_NODES) || this._xaRecoveryNodes.contains(nodeName)) {
                                                    if (jtaLogger.loggerI18N.isDebugEnabled()) {
                                                        jtaLogger.logger.debug(16L, 4L, 2048L, "Will recover this Xid (b)");
                                                    }
                                                    doRecovery = true;
                                                } else if (jtaLogger.loggerI18N.isDebugEnabled()) {
                                                    jtaLogger.logger.debug(16L, 4L, 2048L, "Will not recover this Xid (a)");
                                                }
                                            } else if (jtaLogger.loggerI18N.isDebugEnabled()) {
                                                jtaLogger.logger.debug(16L, 4L, 2048L, "Will not recover this Xid (b)");
                                            }
                                        } else if (jtaLogger.loggerI18N.isDebugEnabled()) {
                                            jtaLogger.logger.debug(16L, 4L, 2048L, "Will not recover this Xid");
                                        }
                                        try {
                                            if (doRecovery) {
                                                if (jtaLogger.loggerI18N.isInfoEnabled()) {
                                                    jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.rollingback", new Object[]{XAHelper.xidToString((Xid)xids[j])});
                                                }
                                                if (!this.transactionLog((Xid)xids[j])) {
                                                    xares.rollback((Xid)xids[j]);
                                                }
                                            } else if (jtaLogger.loggerI18N.isInfoEnabled()) {
                                                jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.notrollback", new Object[]{XAHelper.xidToString((Xid)xids[j])});
                                            }
                                            break block56;
                                        }
                                        catch (XAException e1) {
                                            e1.printStackTrace();
                                            switch (e1.errorCode) {
                                                case -3: {
                                                    break;
                                                }
                                                case 5: 
                                                case 6: 
                                                case 7: 
                                                case 8: 
                                                case 100: {
                                                    if (doForget) break;
                                                    doForget = true;
                                                    break;
                                                }
                                            }
                                        }
                                        catch (Exception e2) {
                                            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                                                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.xarecovery2", new Object[]{this._logName + ".xaRecovery ", e2});
                                            }
                                            break block56;
                                        }
                                    }
                                    foundTransaction = true;
                                    XARecoveryResource record = this._recoveryManagerClass.getResource(recordUid, xares);
                                    int recoveryStatus = record.recover();
                                    if (recoveryStatus != 1 && jtaLogger.loggerI18N.isWarnEnabled()) {
                                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.failedtorecover", new Object[]{this._logName + ".xaRecovery ", new Integer(recoveryStatus)});
                                    }
                                    this.removeFailure(record.getXid(), record.get_uid());
                                }
                                if (doForget) {
                                    try {
                                        xares.forget((Xid)xids[j]);
                                    }
                                    catch (Exception e) {
                                        if (!jtaLogger.loggerI18N.isWarnEnabled()) break block57;
                                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.forgetfailed", new Object[]{this._logName + ".xaRecovery", e});
                                    }
                                }
                            }
                            if (recordUid != null) continue;
                        }
                    }
                }
                catch (Exception e) {
                    if (jtaLogger.loggerI18N.isWarnEnabled()) {
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.generalrecoveryerror", new Object[]{this._logName + ".xaRecovery", e});
                    }
                    e.printStackTrace();
                }
            }
            try {
                if (xares != null) {
                    xares.recover(0x800000);
                }
            }
            catch (XAException e) {
                if (!jtaLogger.loggerI18N.isWarnEnabled()) break block58;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.xarecovery1", new Object[]{this._logName + ".xaRecovery", e, XAHelper.printXAErrorCode(e)});
            }
        }
        return true;
    }

    private final boolean transactionLog(Xid xid) {
        XidImple theXid;
        Uid u;
        if (_transactionStore == null) {
            _transactionStore = TxControl.getStore();
        }
        if (!(u = XATxConverter.getUid((theXid = new XidImple(xid)).getXID())).equals(Uid.nullUid())) {
            try {
                if (_transactionStore.currentState(u, this._transactionType) != 0) {
                    return true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (jtaLogger.logger.isInfoEnabled()) {
            jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.notaxid", new Object[]{xid});
        }
        return false;
    }

    private final Uid previousFailure(Xid xid) {
        if (this._failures == null) {
            return null;
        }
        Enumeration e = this._failures.keys();
        while (e.hasMoreElements()) {
            Xid theXid = (Xid)e.nextElement();
            if (!XAHelper.sameXID(xid, theXid)) continue;
            Vector failureItem = (Vector)this._failures.get(theXid);
            Uid u = (Uid)failureItem.remove(0);
            if (failureItem.size() == 0) {
                this._failures.remove(theXid);
            }
            return u;
        }
        return null;
    }

    private void addFailure(Xid xid, Uid uid) {
        Vector<Uid> failureItem;
        if (this._failures == null) {
            this._failures = new Hashtable();
        }
        if ((failureItem = (Vector<Uid>)this._failures.get(xid)) == null) {
            failureItem = new Vector<Uid>();
            this._failures.put(xid, failureItem);
        }
        failureItem.addElement(uid);
    }

    private void removeFailure(Xid xid, Uid uid) {
        Vector failureItem = (Vector)this._failures.get(xid);
        if (failureItem != null) {
            failureItem.remove(uid);
            if (failureItem.size() == 0) {
                this._failures.remove(xid);
            }
        }
    }

    private void clearAllFailures() {
        if (this._failures != null) {
            this._failures.clear();
        }
    }

    static {
        String env = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.xaBackoffPeriod");
        _backoffPeriod = 20000;
        if (env != null) {
            try {
                Integer i = new Integer(env);
                _backoffPeriod = i;
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

