/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.KeyedReference;

class TModelIdentifierTable {
    private static Log log = LogFactory.getLog((Class)TModelIdentifierTable.class);
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;

    TModelIdentifierTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String tModelKey, Vector keyRefs, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, tModelKey.toString());
            int listSize = keyRefs.size();
            for (int identifierID = 0; identifierID < listSize; ++identifierID) {
                KeyedReference keyRef = (KeyedReference)keyRefs.elementAt(identifierID);
                String tModelKeyValue = null;
                if (keyRef.getTModelKey() != null) {
                    tModelKeyValue = keyRef.getTModelKey().toString();
                }
                statement.setInt(2, identifierID);
                statement.setString(3, tModelKeyValue);
                statement.setString(4, keyRef.getKeyName());
                statement.setString(5, keyRef.getKeyValue());
                log.debug((Object)("insert into TMODEL_IDENTIFIER table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + tModelKey.toString() + "\n\t IDENTIFIER_ID=" + identifierID + "\n\t TMODEL_KEY_REF=" + tModelKeyValue + "\n\t KEY_NAME=" + keyRef.getKeyName() + "\n\t KEY_VALUE=" + keyRef.getKeyValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String tModelKey, Connection connection) throws SQLException {
        Vector<KeyedReference> keyRefList = new Vector<KeyedReference>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, tModelKey.toString());
            log.debug((Object)("select from TMODEL_IDENTIFIER table:\n\n\t" + selectSQL + "\n\t TMODEL_KEY=" + tModelKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                KeyedReference keyRef = new KeyedReference();
                keyRef.setTModelKey(resultSet.getString(1));
                keyRef.setKeyName(resultSet.getString(2));
                keyRef.setKeyValue(resultSet.getString(3));
                keyRefList.add(keyRef);
            }
            Vector<KeyedReference> vector = keyRefList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String tModelKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, tModelKey.toString());
            log.debug((Object)("delete from TMODEL_IDENTIFIER table:\n\n\t" + deleteSQL + "\n\t TMODEL_KEY=" + tModelKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO TMODEL_IDENTIFIER (");
        sql.append("TMODEL_KEY,");
        sql.append("IDENTIFIER_ID,");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE, ");
        sql.append("IDENTIFIER_ID ");
        sql.append("FROM TMODEL_IDENTIFIER ");
        sql.append("WHERE TMODEL_KEY=? ");
        sql.append("ORDER BY IDENTIFIER_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM TMODEL_IDENTIFIER ");
        sql.append("WHERE TMODEL_KEY=?");
        deleteSQL = sql.toString();
    }
}

