/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import javax.xml.transform.ErrorListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.xml.ErrorHandlerAdapter;
import org.jbpm.bpel.xml.ErrorListenerAdapter;
import org.jbpm.bpel.xml.ParseProblem;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.jpdl.xml.Problem;
import org.xml.sax.ErrorHandler;

public abstract class AbstractProblemHandler
implements ProblemHandler {
    private static final Log log = LogFactory.getLog((Class)ProblemHandler.class);

    protected AbstractProblemHandler() {
    }

    public ErrorHandler asSaxErrorHandler() {
        return new ErrorHandlerAdapter(this);
    }

    public ErrorListener asTraxErrorListener() {
        return new ErrorListenerAdapter(this);
    }

    public static void logProblem(Problem problem) {
        ParseProblem parseProblem;
        StringBuffer detailBuffer = new StringBuffer();
        if (problem.getDescription() != null) {
            detailBuffer.append(problem.getDescription());
        }
        if (problem.getResource() != null) {
            detailBuffer.append(": ").append(problem.getResource());
        }
        if (problem.getLine() != null) {
            detailBuffer.append('(').append(problem.getLine()).append(')');
        }
        if (problem instanceof ParseProblem && (parseProblem = (ParseProblem)problem).getLocation() != null) {
            detailBuffer.append(' ').append(parseProblem.getLocation());
        }
        String detail = detailBuffer.toString();
        Throwable exception = problem.getException();
        switch (problem.getLevel()) {
            case 4: {
                log.info((Object)detail, exception);
                break;
            }
            case 3: {
                log.warn((Object)detail, exception);
                break;
            }
            case 2: {
                log.error((Object)detail, exception);
                break;
            }
            case 1: {
                log.fatal((Object)detail, exception);
            }
        }
    }
}

