/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.basic;

import java.io.Serializable;
import org.hibernate.Session;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.alarm.AlarmAction;
import org.jbpm.bpel.alarm.TimeDrivenActivity;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.scheduler.SchedulerService;

public class Wait
extends Activity
implements TimeDrivenActivity {
    private AlarmAction alarmAction;
    private static final long serialVersionUID = 1L;

    public Wait() {
    }

    public Wait(String name) {
        super(name);
    }

    public void terminate(ExecutionContext exeContext) {
        SchedulerService scheduler = AlarmAction.getSchedulerService(exeContext.getJbpmContext());
        this.alarmAction.deleteTimer(exeContext.getToken(), scheduler);
    }

    public void alarmFired(AlarmAction anAlarm, Token token) {
        this.leave(new ExecutionContext(token));
    }

    public AlarmAction getAlarmAction() {
        if (this.action == null) {
            return null;
        }
        if (this.action instanceof AlarmAction) {
            return (AlarmAction)this.action;
        }
        Session hbSession = JbpmContext.getCurrentJbpmContext().getSession();
        AlarmAction alarmAction = (AlarmAction)((Object)hbSession.load(AlarmAction.class, (Serializable)new Long(this.action.getId())));
        this.action = alarmAction;
        return alarmAction;
    }

    public void setAction(Action action) {
        if (!(action instanceof AlarmAction)) {
            throw new IllegalArgumentException("not an alarm action: " + action);
        }
        this.action = action;
        action.setName(this.name);
        ((AlarmAction)action).setTimeDrivenActivity(this);
    }

    public void accept(BpelVisitor visitor) {
        visitor.visit(this);
    }
}

