/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.endpointref.wsa;

import javax.xml.namespace.QName;
import org.jbpm.bpel.endpointref.SoapEndpointReference;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsaEndpointReference
extends SoapEndpointReference {
    protected void readEndpointRef(Element endpointRefElem) {
        Element serviceElem;
        Element addressElem = XmlUtil.getElement(endpointRefElem, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");
        this.setAddress(DatatypeUtil.toString(addressElem));
        Element portTypeElem = XmlUtil.getElement(endpointRefElem, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "PortType");
        if (portTypeElem != null) {
            String portTypeValue = DatatypeUtil.toString(portTypeElem);
            this.setPortTypeName(XmlUtil.parseQName(portTypeValue, portTypeElem));
        }
        if ((serviceElem = XmlUtil.getElement(endpointRefElem, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "ServiceName")) != null) {
            String serviceValue = DatatypeUtil.toString(serviceElem);
            this.setServiceName(XmlUtil.parseQName(serviceValue, serviceElem));
            this.setPortName(XmlUtil.getAttribute(serviceElem, "PortName"));
        }
    }

    protected Element writeEndpointRef(Document nodeFactory) {
        QName serviceName;
        Element endpointRefElem = nodeFactory.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReference");
        XmlUtil.addNamespaceDeclaration(endpointRefElem, "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        Element addressElem = nodeFactory.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");
        endpointRefElem.appendChild(addressElem);
        XmlUtil.setStringValue(addressElem, this.getAddress());
        QName portTypeName = this.getPortTypeName();
        if (portTypeName != null) {
            Element portTypeElem = nodeFactory.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "PortType");
            endpointRefElem.appendChild(portTypeElem);
            XmlUtil.setQNameValue(portTypeElem, portTypeName);
        }
        if ((serviceName = this.getServiceName()) != null) {
            Element serviceElem = nodeFactory.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ServiceName");
            endpointRefElem.appendChild(serviceElem);
            XmlUtil.setQNameValue(serviceElem, serviceName);
            String portName = this.getPortName();
            if (portName != null) {
                serviceElem.setAttribute("PortName", portName);
            }
        }
        return endpointRefElem;
    }
}

