/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public abstract class BaseTableRenderer
extends HtmlBasicRenderer {
    protected abstract void renderHeader(FacesContext var1, UIComponent var2, ResponseWriter var3) throws IOException;

    protected abstract void renderFooter(FacesContext var1, UIComponent var2, ResponseWriter var3) throws IOException;

    protected abstract void renderRow(FacesContext var1, UIComponent var2, UIComponent var3, ResponseWriter var4) throws IOException;

    protected void renderTableStart(FacesContext context, UIComponent table, ResponseWriter writer, String[] passThroughAttributes) throws IOException {
        writer.startElement("table", table);
        this.writeIdAttributeIfNecessary(context, writer, table);
        String styleClass = (String)table.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(writer, table, passThroughAttributes);
        writer.writeText((Object)"\n", table, null);
    }

    protected void renderTableEnd(UIComponent table, ResponseWriter writer) throws IOException {
        writer.endElement("table");
        writer.writeText((Object)"\n", table, null);
    }

    protected void renderCaption(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        UIComponent caption = this.getFacet(table, "caption");
        if (caption != null) {
            String captionClass = (String)table.getAttributes().get("captionClass");
            String captionStyle = (String)table.getAttributes().get("captionStyle");
            writer.startElement("caption", table);
            if (captionClass != null) {
                writer.writeAttribute("class", (Object)captionClass, "captionClass");
            }
            if (captionStyle != null) {
                writer.writeAttribute("style", (Object)captionStyle, "captionStyle");
            }
            this.encodeRecursive(context, caption);
            writer.endElement("caption");
        }
    }

    protected void renderTableBodyStart(UIComponent table, ResponseWriter writer) throws IOException {
        writer.startElement("tbody", table);
        writer.writeText((Object)"\n", table, null);
    }

    protected void renderTableBodyEnd(UIComponent table, ResponseWriter writer) throws IOException {
        writer.endElement("tbody");
        writer.writeText((Object)"\n", table, null);
    }

    protected void renderRowStart(UIComponent table, ResponseWriter writer) throws IOException {
        TableMetaInfo info = this.getMetaInfo(table);
        writer.startElement("tr", table);
        if (info.rowClasses.length > 0) {
            writer.writeAttribute("class", (Object)info.getCurrentRowClass(), "rowClasses");
        }
        writer.writeText((Object)"\n", table, null);
    }

    protected void renderRowEnd(UIComponent table, ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.writeText((Object)"\n", table, null);
    }

    protected TableMetaInfo getMetaInfo(UIComponent table) {
        TableMetaInfo info = (TableMetaInfo)table.getAttributes().get(TableMetaInfo.KEY);
        if (info == null) {
            info = new TableMetaInfo(table);
            table.getAttributes().put(TableMetaInfo.KEY, info);
        }
        return info;
    }

    protected void clearMetaInfo(UIComponent table) {
        table.getAttributes().remove(TableMetaInfo.KEY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TableMetaInfo {
        private static final UIColumn PLACE_HOLDER_COLUMN = new UIColumn();
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        public static final String KEY = TableMetaInfo.class.getName();
        public final String[] rowClasses;
        public final String[] columnClasses;
        public final List<UIColumn> columns;
        public final boolean hasHeaderFacets;
        public final boolean hasFooterFacets;
        public final int columnCount;
        public int columnStyleCounter;
        public int rowStyleCounter;

        public TableMetaInfo(UIComponent table) {
            this.rowClasses = TableMetaInfo.getRowClasses(table);
            this.columnClasses = TableMetaInfo.getColumnClasses(table);
            this.columns = TableMetaInfo.getColumns(table);
            this.columnCount = this.columns.size();
            this.hasHeaderFacets = TableMetaInfo.hasFacet("header", this.columns);
            this.hasFooterFacets = TableMetaInfo.hasFacet("footer", this.columns);
        }

        public void newRow() {
            this.columnStyleCounter = 0;
        }

        public String getCurrentColumnClass() {
            String style = null;
            if (this.columnStyleCounter < this.columnClasses.length && this.columnStyleCounter <= this.columnCount) {
                style = this.columnClasses[this.columnStyleCounter++];
            }
            return style != null && style.length() > 0 ? style : null;
        }

        public String getCurrentRowClass() {
            String style = this.rowClasses[this.rowStyleCounter++];
            if (this.rowStyleCounter >= this.rowClasses.length) {
                this.rowStyleCounter = 0;
            }
            return style;
        }

        private static String[] getColumnClasses(UIComponent table) {
            String values = (String)table.getAttributes().get("columnClasses");
            if (values == null) {
                return EMPTY_STRING_ARRAY;
            }
            return Util.split(values.trim(), ",");
        }

        private static List<UIColumn> getColumns(UIComponent table) {
            if (table instanceof UIData) {
                int childCount = table.getChildCount();
                if (childCount > 0) {
                    ArrayList<UIColumn> results = new ArrayList<UIColumn>(childCount);
                    for (UIComponent kid : table.getChildren()) {
                        if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
                        results.add((UIColumn)kid);
                    }
                    return results;
                }
                return Collections.emptyList();
            }
            Object value = table.getAttributes().get("columns");
            int count = value != null && value instanceof Integer ? (Integer)value : 2;
            if (count < 1) {
                count = 1;
            }
            ArrayList<UIColumn> result = new ArrayList<UIColumn>(count);
            for (int i = 0; i < count; ++i) {
                result.add(PLACE_HOLDER_COLUMN);
            }
            return result;
        }

        private static boolean hasFacet(String name, List<UIColumn> columns) {
            if (!columns.isEmpty()) {
                for (UIColumn column : columns) {
                    if (column.getFacetCount() <= 0 || !column.getFacets().containsKey(name)) continue;
                    return true;
                }
            }
            return false;
        }

        private static String[] getRowClasses(UIComponent table) {
            String values = (String)table.getAttributes().get("rowClasses");
            if (values == null) {
                return EMPTY_STRING_ARRAY;
            }
            return Util.split(values.trim(), ",");
        }
    }
}

