/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.db;

import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.SchedulerSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.scheduler.exe.Timer;

public class DbSchedulerService
implements SchedulerService {
    private static final long serialVersionUID = 1L;
    SchedulerSession schedulerSession = JbpmContext.getCurrentJbpmContext().getSchedulerSession();

    public void createTimer(Timer timer) {
        this.schedulerSession.saveTimer(timer);
    }

    public void cancelTimersByName(String timerName, Token token) {
        this.schedulerSession.cancelTimersByName(timerName, token);
    }

    public void cancelTimersByProcessInstance(ProcessInstance processInstance) {
        if (processInstance == null) {
            throw new JbpmException("couldn't cancel timers for null process instance");
        }
        this.schedulerSession.cancelTimersForProcessInstance(processInstance);
    }

    public void suspendTimers(Token token) {
        this.schedulerSession.suspendTimersForProcessInstance(token);
    }

    public void resumeTimers(Token token) {
        this.schedulerSession.resumeTimersForProcessInstance(token);
    }

    public void close() {
    }
}

