/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionManager;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.blocks.MethodCall;

public class EvictionInterceptor
extends Interceptor {
    private static final Log log = LogFactory.getLog((Class)EvictionInterceptor.class);
    protected RegionManager regionManager;
    protected Map evictionMethodHandlers = new HashMap();

    public EvictionInterceptor() {
        EvictionMethodHandler handler = new GetNodeEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.getNodeMethodLocal, handler);
        this.evictionMethodHandlers.put(MethodDeclarations.getDataMapMethodLocal, handler);
        handler = new GetKeyEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.getKeyValueMethodLocal, handler);
        handler = new RemoveNodeEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.removeNodeMethodLocal, handler);
        this.evictionMethodHandlers.put(MethodDeclarations.removeDataMethodLocal, handler);
        handler = new RemoveKeyEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.removeKeyMethodLocal, handler);
        handler = new PutDataEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.putDataMethodLocal, handler);
        handler = new PutDataEraseEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.putDataEraseMethodLocal, handler);
        handler = new PutKeyEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.putKeyValMethodLocal, handler);
        this.evictionMethodHandlers.put(MethodDeclarations.putFailFastKeyValueMethodLocal, handler);
        handler = new PartialEvictionEvictionMethodHandler();
        this.evictionMethodHandlers.put(MethodDeclarations.evictNodeMethodLocal, handler);
        this.evictionMethodHandlers.put(MethodDeclarations.evictVersionedNodeMethodLocal, handler);
    }

    void setRegionManager(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.regionManager = cache.getEvictionRegionManager();
    }

    public Object invoke(MethodCall m) throws Throwable {
        Object ret = super.invoke(m);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Invoking EvictionInterceptor");
        }
        this.updateNode(m, ret);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Finished invoking EvictionInterceptor");
        }
        return ret;
    }

    protected void updateNode(MethodCall m, Object retVal) {
        EvictedEventNode event;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Updating node/element events with no tx");
        }
        if ((event = this.extractEvent(m, retVal)) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No node modifications");
            }
            return;
        }
        this.doEventUpdatesOnRegionManager(event);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Finished updating node");
        }
    }

    protected EvictedEventNode extractEvent(MethodCall m, Object retVal) {
        EvictionMethodHandler handler = (EvictionMethodHandler)this.evictionMethodHandlers.get(m.getMethod());
        if (handler == null) {
            return null;
        }
        return handler.extractEvictedEventNode(m, retVal);
    }

    protected boolean canIgnoreEvent(Fqn fqn) {
        return this.regionManager.getRegion(fqn).getEvictionPolicy().canIgnoreEvent(fqn);
    }

    protected void doEventUpdatesOnRegionManager(EvictedEventNode event) {
        Region region = this.regionManager.getRegion(event.getFqn());
        region.putNodeEvent(event);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding event " + event.toString() + " to region at " + region.getFqn()));
        }
    }

    protected static interface EvictionMethodHandler {
        public EvictedEventNode extractEvictedEventNode(MethodCall var1, Object var2);
    }

    protected class PartialEvictionEvictionMethodHandler
    implements EvictionMethodHandler {
        protected PartialEvictionEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args;
            Fqn fqn;
            boolean complete;
            boolean bl = complete = retVal != null && (Boolean)retVal != false;
            if (!complete && (fqn = (Fqn)(args = mc.getArgs())[0]) != null && !EvictionInterceptor.this.canIgnoreEvent(fqn)) {
                return new EvictedEventNode(fqn, 0, 0);
            }
            return null;
        }
    }

    protected class PutKeyEvictionMethodHandler
    implements EvictionMethodHandler {
        protected PutKeyEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            Object key = args[2];
            if (fqn != null && key != null && !EvictionInterceptor.this.canIgnoreEvent(fqn)) {
                return new EvictedEventNode(fqn, 3, 1);
            }
            return null;
        }
    }

    protected class PutDataEraseEvictionMethodHandler
    implements EvictionMethodHandler {
        protected PutDataEraseEvictionMethodHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            Map putData = (Map)args[2];
            Boolean resetElementCount = (Boolean)args[4];
            if (fqn != null && !EvictionInterceptor.this.canIgnoreEvent(fqn)) {
                int size;
                if (putData == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Putting null data under fqn " + fqn + "."));
                    }
                    return null;
                }
                Map map = putData;
                synchronized (map) {
                    size = putData.size();
                }
                EvictedEventNode event = new EvictedEventNode(fqn, 0, size);
                event.setResetElementCount(resetElementCount);
                return event;
            }
            return null;
        }
    }

    protected class PutDataEvictionMethodHandler
    implements EvictionMethodHandler {
        protected PutDataEvictionMethodHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            Map putData = (Map)args[2];
            if (fqn != null && !EvictionInterceptor.this.canIgnoreEvent(fqn)) {
                int size;
                if (putData == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Putting null data under fqn " + fqn + "."));
                    }
                    return null;
                }
                Map map = putData;
                synchronized (map) {
                    size = putData.size();
                }
                return new EvictedEventNode(fqn, 0, size);
            }
            return null;
        }
    }

    protected class RemoveKeyEvictionMethodHandler
    implements EvictionMethodHandler {
        protected RemoveKeyEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            if (retVal == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No event added. Element does not exist");
                }
                return null;
            }
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            Object key = args[2];
            if (fqn != null && key != null && !EvictionInterceptor.this.canIgnoreEvent(fqn)) {
                return new EvictedEventNode(fqn, 4, 1);
            }
            return null;
        }
    }

    protected class RemoveNodeEvictionMethodHandler
    implements EvictionMethodHandler {
        protected RemoveNodeEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            if (fqn != null && !EvictionInterceptor.this.canIgnoreEvent(fqn)) {
                return new EvictedEventNode(fqn, 1);
            }
            return null;
        }
    }

    protected class GetKeyEvictionMethodHandler
    implements EvictionMethodHandler {
        protected GetKeyEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            if (retVal == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No event added. Element does not exist");
                }
                return null;
            }
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[0];
            Object key = args[1];
            if (fqn != null && key != null && !EvictionInterceptor.this.canIgnoreEvent(fqn)) {
                return new EvictedEventNode(fqn, 2);
            }
            return null;
        }
    }

    protected class GetNodeEvictionMethodHandler
    implements EvictionMethodHandler {
        protected GetNodeEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            if (retVal == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No event added. Node does not exist");
                }
                return null;
            }
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[0];
            if (fqn != null && !EvictionInterceptor.this.canIgnoreEvent(fqn)) {
                Region region = EvictionInterceptor.this.regionManager.getRegion(fqn);
                if (region.getEvictionPolicy().canIgnoreEvent(fqn)) {
                    return null;
                }
                return new EvictedEventNode(fqn, 2);
            }
            return null;
        }
    }
}

