/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.output;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;
import org.junitee.output.OutputProducer;
import org.junitee.runner.TestInfo;
import org.junitee.runner.TestRunnerResults;

public abstract class AbstractOutput
implements OutputProducer {
    private TestRunnerResults results;
    private boolean filterTrace = true;

    public AbstractOutput(TestRunnerResults results, boolean filterTrace) {
        this.results = results;
        this.filterTrace = filterTrace;
    }

    public abstract void render();

    public synchronized TestInfo getCurrentInfo() {
        TestRunnerResults testRunnerResults = this.results;
        synchronized (testRunnerResults) {
            TestInfo testInfo = this.results.getCurrentInfo();
            return testInfo;
        }
    }

    protected long getTimestamp() {
        TestRunnerResults testRunnerResults = this.results;
        synchronized (testRunnerResults) {
            long l = this.results.getTimestamp();
            return l;
        }
    }

    protected List getSuiteInfo() {
        TestRunnerResults testRunnerResults = this.results;
        synchronized (testRunnerResults) {
            List list = this.results.getSuiteInfo();
            return list;
        }
    }

    protected boolean isFailure() {
        TestRunnerResults testRunnerResults = this.results;
        synchronized (testRunnerResults) {
            boolean bl = this.results.isFailure();
            return bl;
        }
    }

    protected boolean isFilterTrace() {
        return this.filterTrace;
    }

    protected boolean isSingleTest() {
        TestRunnerResults testRunnerResults = this.results;
        synchronized (testRunnerResults) {
            boolean bl = this.results.isSingleTest();
            return bl;
        }
    }

    protected boolean isFinished() {
        TestRunnerResults testRunnerResults = this.results;
        synchronized (testRunnerResults) {
            boolean bl = this.results.isFinished();
            return bl;
        }
    }

    protected boolean isStopped() {
        TestRunnerResults testRunnerResults = this.results;
        synchronized (testRunnerResults) {
            boolean bl = this.results.isStopped();
            return bl;
        }
    }

    protected List getErrorMessages() {
        TestRunnerResults testRunnerResults = this.results;
        synchronized (testRunnerResults) {
            List list = this.results.getErrorMessages();
            return list;
        }
    }

    protected String exceptionToString(Throwable t) {
        CharArrayWriter buffer = new CharArrayWriter();
        t.printStackTrace(new PrintWriter(buffer));
        return buffer.toString();
    }

    protected String getEJBExceptionDetail(Throwable t) {
        if (t instanceof RemoteException) {
            EJBException ejbe;
            RemoteException remote = (RemoteException)t;
            if (remote.detail != null && remote.detail instanceof EJBException && (ejbe = (EJBException)remote.detail).getCausedByException() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter spw = new PrintWriter(sw);
                spw.println("Nested exception is: ");
                ejbe.getCausedByException().printStackTrace(spw);
                return sw.toString();
            }
        }
        return "";
    }
}

