/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class SignalCommand
implements Command {
    private static final long serialVersionUID = 1L;
    long tokenId = 0L;
    String transitionName = null;
    Token previousToken = null;
    ProcessInstance previousProcessInstance = null;
    private Map variables;
    private static Log log = LogFactory.getLog((Class)SignalCommand.class);

    public SignalCommand() {
    }

    public SignalCommand(long tokenId, String transitionName) {
        this.tokenId = tokenId;
        this.transitionName = transitionName;
    }

    public Object execute(JbpmContext jbpmContext) {
        log.debug((Object)("executing " + this));
        if (this.previousProcessInstance != null) {
            if (this.variables != null && this.variables.size() > 0) {
                this.previousProcessInstance.getContextInstance().addVariables(this.variables);
            }
            if (this.transitionName == null) {
                this.previousProcessInstance.signal();
            } else {
                this.previousProcessInstance.signal(this.transitionName);
            }
            return this.previousProcessInstance.getRootToken();
        }
        Token token = this.getToken(jbpmContext);
        if (this.variables != null && this.variables.size() > 0) {
            token.getProcessInstance().getContextInstance().addVariables(this.variables);
        }
        if (this.transitionName == null) {
            token.signal();
        } else {
            token.signal(this.transitionName);
        }
        return token;
    }

    protected Token getToken(JbpmContext jbpmContext) {
        if (this.previousToken != null) {
            return this.previousToken;
        }
        return jbpmContext.loadTokenForUpdate(this.tokenId);
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(long tokenId) {
        this.tokenId = tokenId;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }
}

