/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.Utf8CPInfo;

public class Utils {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SUPER = 32;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_STRICT = 2048;

    private Utils() {
    }

    public static String getUTF8Value(ConstantPool pool, int index) {
        return ((Utf8CPInfo)pool.getEntry(index)).getValue();
    }

    public static String[] getMethodParams(String descriptor) {
        int i = 0;
        if (descriptor.charAt(i) != '(') {
            throw new IllegalArgumentException("Method descriptor should start with a '('");
        }
        Vector<String> params = new Vector<String>();
        StringBuffer param = new StringBuffer();
        ++i;
        while ((i = Utils.descriptor2java(descriptor, i, param)) < descriptor.length()) {
            params.add(param.substring(0));
            param = new StringBuffer();
            if (descriptor.charAt(i) != ')') continue;
            ++i;
            break;
        }
        Object[] array = new String[params.size()];
        params.copyInto(array);
        return array;
    }

    public static String getMethodReturnType(String descriptor) {
        int pos = descriptor.indexOf(41);
        StringBuffer rettype = new StringBuffer();
        Utils.descriptor2java(descriptor, pos + 1, rettype);
        return rettype.toString();
    }

    public static int descriptor2java(String descriptor, int i, StringBuffer sb) {
        StringBuffer dim = new StringBuffer();
        while (descriptor.charAt(i) == '[') {
            dim.append("[]");
            ++i;
        }
        switch (descriptor.charAt(i)) {
            case 'B': {
                sb.append("byte");
                break;
            }
            case 'C': {
                sb.append("char");
                break;
            }
            case 'D': {
                sb.append("double");
                break;
            }
            case 'F': {
                sb.append("float");
                break;
            }
            case 'I': {
                sb.append("int");
                break;
            }
            case 'J': {
                sb.append("long");
                break;
            }
            case 'S': {
                sb.append("short");
                break;
            }
            case 'Z': {
                sb.append("boolean");
                break;
            }
            case 'V': {
                sb.append("void");
                break;
            }
            case 'L': {
                int pos = descriptor.indexOf(59, i + 1);
                String classname = descriptor.substring(i + 1, pos).replace('/', '.');
                sb.append(classname);
                i = pos;
                break;
            }
        }
        sb.append(dim.toString());
        return ++i;
    }

    public static boolean isAbstract(int access_flags) {
        return (access_flags & 0x400) != 0;
    }

    public static boolean isPublic(int access_flags) {
        return (access_flags & 1) != 0;
    }

    public static boolean isStatic(int access_flags) {
        return (access_flags & 8) != 0;
    }

    public static boolean isNative(int access_flags) {
        return (access_flags & 0x100) != 0;
    }

    public static boolean isClass(int access_flags) {
        return !Utils.isInterface(access_flags);
    }

    public static boolean isStrict(int access_flags) {
        return (access_flags & 0x800) != 0;
    }

    public static boolean isInterface(int access_flags) {
        return (access_flags & 0x200) != 0;
    }

    public static boolean isPrivate(int access_flags) {
        return (access_flags & 2) != 0;
    }

    public static boolean isTransient(int access_flags) {
        return (access_flags & 0x80) != 0;
    }

    public static boolean isVolatile(int access_flags) {
        return (access_flags & 0x40) != 0;
    }

    public static boolean isSuper(int access_flags) {
        return (access_flags & 0x20) != 0;
    }

    public static boolean isProtected(int access_flags) {
        return (access_flags & 4) != 0;
    }

    public static boolean isFinal(int access_flags) {
        return (access_flags & 0x10) != 0;
    }

    public static boolean isSynchronized(int access_flags) {
        return (access_flags & 0x20) != 0;
    }

    public static String getMethodAccess(int access_flags) {
        StringBuffer sb = new StringBuffer();
        if (Utils.isPublic(access_flags)) {
            sb.append("public ");
        } else if (Utils.isPrivate(access_flags)) {
            sb.append("private ");
        } else if (Utils.isProtected(access_flags)) {
            sb.append("protected ");
        }
        if (Utils.isFinal(access_flags)) {
            sb.append("final ");
        }
        if (Utils.isStatic(access_flags)) {
            sb.append("static ");
        }
        if (Utils.isSynchronized(access_flags)) {
            sb.append("synchronized ");
        }
        if (Utils.isNative(access_flags)) {
            sb.append("native ");
        }
        if (Utils.isAbstract(access_flags)) {
            sb.append("abstract ");
        }
        return sb.toString().trim();
    }

    public static String getFieldAccess(int access_flags) {
        StringBuffer sb = new StringBuffer();
        if (Utils.isPublic(access_flags)) {
            sb.append("public ");
        } else if (Utils.isPrivate(access_flags)) {
            sb.append("private ");
        } else if (Utils.isProtected(access_flags)) {
            sb.append("protected ");
        }
        if (Utils.isFinal(access_flags)) {
            sb.append("final ");
        }
        if (Utils.isStatic(access_flags)) {
            sb.append("static ");
        }
        if (Utils.isVolatile(access_flags)) {
            sb.append("volatile ");
        }
        if (Utils.isTransient(access_flags)) {
            sb.append("transient ");
        }
        return sb.toString().trim();
    }

    public static String getClassAccess(int access_flags) {
        StringBuffer sb = new StringBuffer();
        if (Utils.isPublic(access_flags)) {
            sb.append("public ");
        } else if (Utils.isProtected(access_flags)) {
            sb.append("protected ");
        } else if (Utils.isPrivate(access_flags)) {
            sb.append("private ");
        }
        if (Utils.isFinal(access_flags)) {
            sb.append("final ");
        }
        if (Utils.isSuper(access_flags)) {
            sb.append("/*super*/ ");
        }
        if (Utils.isInterface(access_flags)) {
            sb.append("interface ");
        }
        if (Utils.isAbstract(access_flags)) {
            sb.append("abstract ");
        }
        if (Utils.isClass(access_flags)) {
            sb.append("class ");
        }
        return sb.toString().trim();
    }
}

