/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.Test;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.test.BaseTestCase;
import org.apache.velocity.test.TemplateTestBase;

public class EncodingTestCase
extends BaseTestCase
implements TemplateTestBase {
    public EncodingTestCase() {
        super("EncodingTestCase");
        try {
            Velocity.setProperty("file.resource.loader.path", "../test/templates");
            Velocity.setProperty("input.encoding", "UTF-8");
            Velocity.init();
        }
        catch (Exception e) {
            System.err.println("Cannot setup EncodingTestCase!");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Test suite() {
        return new EncodingTestCase();
    }

    public void runTest() {
        VelocityContext context = new VelocityContext();
        try {
            EncodingTestCase.assureResultsDirectoryExists("../test/templates/results");
            Template template = Velocity.getTemplate(EncodingTestCase.getFileName(null, "encodingtest", "vm"), "UTF-8");
            FileOutputStream fos = new FileOutputStream(EncodingTestCase.getFileName("../test/templates/results", "encodingtest", "res"));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            template.merge(context, writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            if (!this.isMatch("../test/templates/results", "../test/templates/compare", "encodingtest", "res", "cmp")) {
                EncodingTestCase.fail((String)"Output 1 incorrect.");
            }
            template = Velocity.getTemplate(EncodingTestCase.getFileName(null, "encodingtest2", "vm"), "UTF-8");
            fos = new FileOutputStream(EncodingTestCase.getFileName("../test/templates/results", "encodingtest2", "res"));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            template.merge(context, writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            if (!this.isMatch("../test/templates/results", "../test/templates/compare", "encodingtest2", "res", "cmp")) {
                EncodingTestCase.fail((String)"Output 2 incorrect.");
            }
            template = Velocity.getTemplate(EncodingTestCase.getFileName(null, "encodingtest3", "vm"), "GBK");
            fos = new FileOutputStream(EncodingTestCase.getFileName("../test/templates/results", "encodingtest3", "res"));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "GBK"));
            template.merge(context, writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            if (!this.isMatch("../test/templates/results", "../test/templates/compare", "encodingtest3", "res", "cmp")) {
                EncodingTestCase.fail((String)"Output 3 incorrect.");
            }
            template = Velocity.getTemplate(EncodingTestCase.getFileName(null, "encodingtest_KOI8-R", "vm"), "KOI8-R");
            fos = new FileOutputStream(EncodingTestCase.getFileName("../test/templates/results", "encodingtest_KOI8-R", "res"));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "KOI8-R"));
            template.merge(context, writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            if (!this.isMatch("../test/templates/results", "../test/templates/compare", "encodingtest_KOI8-R", "res", "cmp")) {
                EncodingTestCase.fail((String)"Output 4 incorrect.");
            }
        }
        catch (Exception e) {
            EncodingTestCase.fail((String)e.getMessage());
        }
    }
}

