/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;

public class Log4jProxy
implements Log,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PROXY_FQCN = "org.apache.commons.logging.impl.Log4jProxy";
    private Object FATAL;
    private Object ERROR;
    private Object WARN;
    private Object INFO;
    private Object DEBUG;
    private Object TRACE;
    private transient Object logger = null;
    private Method isEnabledFor;
    private Method log;
    static /* synthetic */ Class class$org$apache$commons$logging$impl$Log4jProxy;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;

    static ClassLoader threadContextClassLoader() {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> levelClass = loader.loadClass("org.apache.log4j.Level");
                }
                catch (ClassNotFoundException e) {
                    loader = (class$org$apache$commons$logging$impl$Log4jProxy == null ? (class$org$apache$commons$logging$impl$Log4jProxy = Log4jProxy.class$(Log4jProxy.PROXY_FQCN)) : class$org$apache$commons$logging$impl$Log4jProxy).getClassLoader();
                }
                return loader;
            }
        };
        ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(action);
        return tcl;
    }

    Log4jProxy(String name) {
        ClassLoader tcl = Log4jProxy.threadContextClassLoader();
        try {
            Class<?> levelClass = tcl.loadClass("org.apache.log4j.Level");
            Class[] sig = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Log4jProxy.class$("java.lang.String")) : class$java$lang$String};
            Method toLevel = levelClass.getMethod("toLevel", sig);
            Object[] level = new String[]{"FATAL"};
            this.FATAL = toLevel.invoke(null, level);
            level[0] = "ERROR";
            this.ERROR = toLevel.invoke(null, level);
            level[0] = "WARN";
            this.WARN = toLevel.invoke(null, level);
            level[0] = "INFO";
            this.INFO = toLevel.invoke(null, level);
            level[0] = "DEBUG";
            this.TRACE = this.DEBUG = toLevel.invoke(null, level);
            try {
                levelClass = tcl.loadClass("org.jboss.logging.XLevel");
                Class[] toLevelSig = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Log4jProxy.class$("java.lang.String")) : class$java$lang$String, this.DEBUG.getClass()};
                toLevel = levelClass.getMethod("toLevel", toLevelSig);
                Object[] args = new Object[]{"TRACE", this.DEBUG};
                this.TRACE = toLevel.invoke(null, args);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            Class<?> loggerClass = tcl.loadClass("org.apache.log4j.Logger");
            Method getLogger = loggerClass.getMethod("getLogger", sig);
            Object[] args = new Object[]{name};
            this.logger = getLogger.invoke(null, args);
            Class<?> priorityClass = tcl.loadClass("org.apache.log4j.Priority");
            Class[] isEnabledForSig = new Class[]{priorityClass};
            this.isEnabledFor = loggerClass.getMethod("isEnabledFor", isEnabledForSig);
            Class[] logSig = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Log4jProxy.class$("java.lang.String")) : class$java$lang$String, priorityClass, class$java$lang$Object == null ? (class$java$lang$Object = Log4jProxy.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Throwable == null ? (class$java$lang$Throwable = Log4jProxy.class$("java.lang.Throwable")) : class$java$lang$Throwable};
            this.log = loggerClass.getMethod("log", logSig);
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(this.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.isEnabledFor(this.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.isEnabledFor(this.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(this.INFO);
    }

    public boolean isTraceEnabled() {
        return this.isEnabledFor(this.TRACE);
    }

    public boolean isWarnEnabled() {
        return this.isEnabledFor(this.WARN);
    }

    public void trace(Object message) {
        this.log(this.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log(this.TRACE, message, t);
    }

    public void debug(Object message) {
        this.log(this.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.log(this.DEBUG, message, t);
    }

    public void info(Object message) {
        this.log(this.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(this.INFO, message, t);
    }

    public void warn(Object message) {
        this.log(this.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(this.WARN, message, t);
    }

    public void error(Object message) {
        this.log(this.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(this.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.log(this.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(this.FATAL, message, t);
    }

    private void log(Object level, Object message, Throwable t) {
        Object[] args = new Object[]{PROXY_FQCN, level, message, t};
        try {
            this.log.invoke(this.logger, args);
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (InvocationTargetException e) {
            throw new UndeclaredThrowableException(e.getTargetException());
        }
    }

    private boolean isEnabledFor(Object level) {
        Object[] args = new Object[]{level};
        try {
            Boolean flag = (Boolean)this.isEnabledFor.invoke(this.logger, args);
            return flag;
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (InvocationTargetException e) {
            throw new UndeclaredThrowableException(e.getTargetException());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

