/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jboss.dependency.plugins.AbstractDependencyInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractControllerContext
extends JBossObject
implements ControllerContext {
    private Object name;
    private Object target;
    private Controller controller;
    private ControllerState state = ControllerState.ERROR;
    private ControllerState requiredState = ControllerState.NOT_INSTALLED;
    private ControllerMode mode = ControllerMode.AUTOMATIC;
    private ControllerContextActions actions;
    private DependencyInfo dependencies;
    private Throwable error;

    public AbstractControllerContext(Object object, ControllerContextActions controllerContextActions) {
        this(object, controllerContextActions, null, null);
    }

    public AbstractControllerContext(Object object, ControllerContextActions controllerContextActions, DependencyInfo dependencyInfo) {
        this(object, controllerContextActions, dependencyInfo, null);
    }

    public AbstractControllerContext(Object object, ControllerContextActions controllerContextActions, DependencyInfo dependencyInfo, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (controllerContextActions == null) {
            throw new IllegalArgumentException("Null actions");
        }
        this.name = object;
        this.actions = controllerContextActions;
        this.dependencies = dependencyInfo == null ? new AbstractDependencyInfo() : dependencyInfo;
        this.target = object2;
    }

    public AbstractControllerContext(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = object;
        this.target = object2;
    }

    public Object getName() {
        return this.name;
    }

    public void setName(Object object) {
        this.name = object;
    }

    public ControllerState getState() {
        return this.state;
    }

    public ControllerState getRequiredState() {
        return this.requiredState;
    }

    public void setRequiredState(ControllerState controllerState) {
        this.requiredState = controllerState;
    }

    public ControllerMode getMode() {
        return this.mode;
    }

    public void setMode(ControllerMode controllerMode) {
        this.mode = controllerMode;
        this.flushJBossObjectCache();
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.flushJBossObjectCache();
    }

    public DependencyInfo getDependencyInfo() {
        return this.dependencies;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object object) {
        this.target = object;
        this.flushJBossObjectCache();
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable throwable) {
        this.error = throwable;
        this.state = ControllerState.ERROR;
        this.flushJBossObjectCache();
    }

    public void install(ControllerState controllerState, ControllerState controllerState2) throws Throwable {
        this.error = null;
        this.actions.install(this, controllerState, controllerState2);
        this.state = controllerState2;
        this.flushJBossObjectCache();
    }

    public void uninstall(ControllerState controllerState, ControllerState controllerState2) {
        this.error = null;
        this.state = controllerState2;
        this.flushJBossObjectCache();
        this.actions.uninstall(this, controllerState, controllerState2);
    }

    public void toString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append("name=").append(this.name);
        jBossStringBuilder.append(" target=").append(this.target);
        if (this.error != null || !this.state.equals((Object)ControllerState.ERROR)) {
            jBossStringBuilder.append(" state=").append(this.state.getStateString());
        }
        if (!ControllerMode.AUTOMATIC.equals((Object)this.mode)) {
            jBossStringBuilder.append(" mode=").append(this.mode.getModeString());
            jBossStringBuilder.append(" requiredState=").append(this.requiredState.getStateString());
        }
        if (this.dependencies != null) {
            jBossStringBuilder.append(" depends=").append((Object)this.dependencies);
        }
        if (this.error != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.error.printStackTrace(printWriter);
            printWriter.flush();
            jBossStringBuilder.append(" error=").append(stringWriter.getBuffer());
        }
    }

    public void toShortString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append("name=").append(this.name);
        if (this.error != null || !this.state.equals((Object)ControllerState.ERROR)) {
            jBossStringBuilder.append(" state=").append(this.state.getStateString());
        }
        if (!ControllerMode.AUTOMATIC.equals((Object)this.mode)) {
            jBossStringBuilder.append(" mode=").append(this.mode.getModeString());
            jBossStringBuilder.append(" requiredState=").append(this.requiredState.getStateString());
        }
        if (this.error != null) {
            jBossStringBuilder.append(" error=").append(this.error.getClass().getName()).append(": ").append(this.error.getMessage());
        }
    }
}

