/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.ExitJDialog;
import ccl.swing.OKCancelPanel;
import ccl.swing.SwingUtil;
import ccl.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputCancelDialog
extends ExitJDialog {
    private JTextField _txtInput = null;
    private OKCancelPanel _pOKCancelPanel = null;
    private String _sValue = "";
    private JComboBox _comboBox = null;

    private void _createTextField(String sInit_) {
        this._txtInput = new JTextField(30);
        this._txtInput.setBorder(SwingUtil.createCCLBorder());
        this._txtInput.setText(sInit_);
        SwingUtil.setInitialFocus(this, this._getInputComponent());
    }

    private void _createComboBox(String sInit_, Vector vHistory_, boolean bEditable_) {
        this._comboBox = new JComboBox();
        this._comboBox.setPreferredSize(new Dimension(360, 30));
        this._comboBox.setBorder(SwingUtil.createCCLBorder());
        this._comboBox.setEditable(bEditable_);
        this._comboBox.addItem(sInit_);
        Enumeration eHistory = vHistory_.elements();
        while (eHistory.hasMoreElements()) {
            String sNextHistory = (String)eHistory.nextElement();
            if (sInit_.equals(sNextHistory)) continue;
            this._comboBox.addItem(sNextHistory);
        }
        this._comboBox.setSelectedItem(sInit_);
        SwingUtil.setInitialFocus(this, this._comboBox.getEditor().getEditorComponent());
    }

    private JComponent _getInputComponent() {
        if (this._txtInput != null) {
            return this._txtInput;
        }
        return this._comboBox;
    }

    private void _addInputComponent(String sInit_, Vector vHistory_, boolean bEditable_) {
        if (vHistory_ == null) {
            this._createTextField(sInit_);
        } else {
            this._createComboBox(sInit_, vHistory_, bEditable_);
        }
        this.getContentPane().add(this._getInputComponent());
    }

    public InputCancelDialog(Frame frmParent_, String sPrint_, String sInit_) {
        this(frmParent_, sPrint_, sInit_, null);
    }

    public InputCancelDialog(Frame frmParent_, String sPrint_, String sInit_, Vector vHistory_) {
        this(frmParent_, sPrint_, sInit_, vHistory_, true);
    }

    public InputCancelDialog(Frame frmParent_, String sPrint_, String sInit_, Vector vHistory_, boolean bEditable_) {
        super(frmParent_, "Input", true);
        Util.panicIf(sPrint_ == null);
        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        this.getContentPane().setLayout(pAutoGridBagLayout);
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.getContentPane().add(new JLabel(sPrint_));
        this._addInputComponent(sInit_, vHistory_, bEditable_);
        pAutoGridBagLayout.endLine();
        this._pOKCancelPanel = new OKCancelPanel(this);
        pAutoGridBagLayout.skip();
        pAutoGridBagLayout.setAnchor(13);
        this.getContentPane().add(this._pOKCancelPanel);
        this.pack();
        SwingUtil.centerComponent(this);
    }

    public boolean isOK() {
        return this._pOKCancelPanel.isOK();
    }

    public String getValue() {
        if (!this.isOK()) {
            return null;
        }
        String sRetVal = null;
        sRetVal = this._txtInput != null ? this._txtInput.getText() : this._comboBox.getSelectedItem().toString();
        return sRetVal;
    }

    public static void updateHistory(Vector vHistory_, String sNewElement_) {
        if (!Util.isEmpty(sNewElement_)) {
            vHistory_.removeElement(sNewElement_);
            vHistory_.insertElementAt(sNewElement_, 0);
        }
        while (vHistory_.size() > 20) {
            vHistory_.removeElementAt(20);
        }
    }

    public static String input(Frame frmParent_, String sPrint_, String sInit_, Vector vHistory_) {
        return InputCancelDialog.input(frmParent_, sPrint_, sInit_, vHistory_, true);
    }

    public static String input(Frame frmParent_, String sPrint_, String sInit_, Vector vHistory_, boolean bEditable_) {
        String sRetVal = null;
        InputCancelDialog dlgInput = new InputCancelDialog(frmParent_, sPrint_, sInit_, vHistory_, bEditable_);
        ((Component)dlgInput).setVisible(true);
        if (dlgInput.isOK()) {
            sRetVal = dlgInput.getValue();
            InputCancelDialog.updateHistory(vHistory_, sRetVal);
        }
        dlgInput.dispose();
        return sRetVal;
    }
}

