/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap.basic;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.jboss.kernel.plugins.bootstrap.AbstractBootstrap;
import org.jboss.kernel.plugins.config.property.PropertyKernelConfig;
import org.jboss.kernel.spi.config.KernelConfig;

public class BasicBootstrap
extends AbstractBootstrap {
    public static void main(String[] stringArray) throws Exception {
        BasicBootstrap basicBootstrap = new BasicBootstrap();
        basicBootstrap.run();
    }

    public BasicBootstrap() throws Exception {
        Properties properties = this.getSystemProperties();
        final PropertyKernelConfig propertyKernelConfig = new PropertyKernelConfig(properties);
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                BasicBootstrap.this.setConfig(propertyKernelConfig);
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction);
    }

    public BasicBootstrap(final KernelConfig kernelConfig) throws Exception {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                BasicBootstrap.this.setConfig(kernelConfig);
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction);
    }

    private Properties getSystemProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return (Properties)AccessController.doPrivileged(GetSystemProperties.instance);
    }

    private static class GetSystemProperties
    implements PrivilegedAction {
        private static GetSystemProperties instance = new GetSystemProperties();

        private GetSystemProperties() {
        }

        public Object run() {
            return System.getProperties();
        }
    }
}

