/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import EDU.oswego.cs.dl.util.concurrent.CondVar;
import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.TimeoutException;
import org.jgroups.util.QueueClosedException;

public class Queue2 {
    Element head = null;
    Element tail = null;
    boolean closed = false;
    int size = 0;
    final Sync mutex = new Mutex();
    final CondVar add_condvar = new CondVar(this.mutex);
    final CondVar remove_condvar = new CondVar(this.mutex);
    int num_markers = 0;
    protected static final Log log = LogFactory.getLog((Class)Queue2.class);
    private static final Object endMarker = new Object();

    public Object getFirst() {
        return this.head != null ? this.head.obj : null;
    }

    public Object getLast() {
        return this.tail != null ? this.tail.obj : null;
    }

    public boolean closed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (!log.isErrorEnabled()) return;
            log.error((Object)"argument must not be null");
            return;
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue2.add(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        try {
            try {
                this.mutex.acquire();
                Element el = new Element(obj);
                if (this.head == null) {
                    this.tail = this.head = el;
                    this.size = 1;
                } else {
                    this.tail.next = el;
                    this.tail = el;
                    ++this.size;
                }
                this.add_condvar.broadcast();
            }
            catch (InterruptedException interruptedException) {
                Object var4_5 = null;
                this.mutex.release();
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.mutex.release();
            throw throwable;
        }
        this.mutex.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAtHead(Object obj) throws QueueClosedException {
        if (obj == null) {
            if (!log.isErrorEnabled()) return;
            log.error((Object)"argument must not be null");
            return;
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue2.addAtHead(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        try {
            try {
                this.mutex.acquire();
                Element el = new Element(obj);
                if (this.head == null) {
                    this.tail = this.head = el;
                    this.size = 1;
                } else {
                    el.next = this.head;
                    this.head = el;
                    ++this.size;
                }
                this.add_condvar.broadcast();
            }
            catch (InterruptedException interruptedException) {
                Object var4_5 = null;
                this.mutex.release();
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.mutex.release();
            throw throwable;
        }
        this.mutex.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object remove() throws QueueClosedException {
        Object retval;
        block11: {
            retval = null;
            try {
                block10: {
                    try {
                        this.mutex.acquire();
                        while (this.size == 0) {
                            if (this.closed) {
                                throw new QueueClosedException();
                            }
                            try {
                                this.add_condvar.await();
                            }
                            catch (InterruptedException ex) {}
                        }
                        if (this.closed) {
                            throw new QueueClosedException();
                        }
                        retval = this.removeInternal();
                        if (retval != null || !log.isErrorEnabled()) break block10;
                        log.error((Object)"element was null, should never be the case");
                    }
                    catch (InterruptedException interruptedException) {
                        Object var4_5 = null;
                        this.mutex.release();
                        break block11;
                    }
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.mutex.release();
                throw throwable;
            }
            this.mutex.release();
        }
        if (retval == endMarker) {
            this.close(false);
            throw new QueueClosedException();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object remove(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        try {
            try {
                this.mutex.acquire();
                if (this.size == 0) {
                    if (this.closed) {
                        throw new QueueClosedException();
                    }
                    try {
                        this.add_condvar.timedwait(timeout);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (this.closed) {
                    throw new QueueClosedException();
                }
                retval = this.removeInternal();
                if (retval == null) {
                    throw new TimeoutException();
                }
                if (retval == endMarker) {
                    this.close(false);
                    throw new QueueClosedException();
                }
                Object var6_5 = null;
            }
            catch (InterruptedException e) {
                Object var6_6 = null;
                this.mutex.release();
                return retval;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.mutex.release();
            throw throwable;
        }
        this.mutex.release();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeElement(Object obj) throws QueueClosedException {
        boolean removed;
        block19: {
            block18: {
                block16: {
                    block17: {
                        removed = false;
                        if (obj == null) {
                            if (!log.isErrorEnabled()) return;
                            log.error((Object)"argument must not be null");
                            return;
                        }
                        try {
                            try {
                                this.mutex.acquire();
                                Element el = this.head;
                                if (el == null) {
                                    Object var7_4 = null;
                                    if (!removed) break block16;
                                    break block17;
                                }
                                if (el.obj.equals(obj)) {
                                    this.head = el.next;
                                    el.next = null;
                                    if (this.size == 1) {
                                        this.tail = this.head;
                                    }
                                    this.decrementSize();
                                    removed = true;
                                    break block18;
                                }
                                while (el.next != null) {
                                    if (el.next.obj.equals(obj)) {
                                        Element tmp_el = el.next;
                                        if (tmp_el == this.tail) {
                                            this.tail = el;
                                        }
                                        el.next = el.next.next;
                                        tmp_el.next = null;
                                        this.decrementSize();
                                        removed = true;
                                        break block19;
                                    }
                                    el = el.next;
                                }
                                break block19;
                            }
                            catch (InterruptedException e) {
                                Object var7_7 = null;
                                if (removed) {
                                    this.remove_condvar.broadcast();
                                }
                                this.mutex.release();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            if (removed) {
                                this.remove_condvar.broadcast();
                            }
                            this.mutex.release();
                            throw throwable;
                        }
                    }
                    this.remove_condvar.broadcast();
                }
                this.mutex.release();
                return;
            }
            Object var7_5 = null;
            if (removed) {
                this.remove_condvar.broadcast();
            }
            this.mutex.release();
            return;
        }
        Object var7_6 = null;
        if (removed) {
            this.remove_condvar.broadcast();
        }
        this.mutex.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object peek() throws QueueClosedException {
        Object retval;
        block11: {
            retval = null;
            try {
                block10: {
                    try {
                        this.mutex.acquire();
                        while (this.size == 0) {
                            if (this.closed) {
                                throw new QueueClosedException();
                            }
                            try {
                                this.add_condvar.await();
                            }
                            catch (InterruptedException ex) {}
                        }
                        if (this.closed) {
                            throw new QueueClosedException();
                        }
                        Object object = retval = this.head != null ? this.head.obj : null;
                        if (retval != null || !log.isErrorEnabled()) break block10;
                        log.error((Object)("retval is null: head=" + this.head + ", tail=" + this.tail + ", size()=" + this.size() + ", num_markers=" + this.num_markers + ", closed()=" + this.closed()));
                    }
                    catch (InterruptedException interruptedException) {
                        Object var4_5 = null;
                        this.mutex.release();
                        break block11;
                    }
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.mutex.release();
                throw throwable;
            }
            this.mutex.release();
        }
        if (retval == endMarker) {
            this.close(false);
            throw new QueueClosedException();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object peek(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        try {
            try {
                this.mutex.acquire();
                if (this.size == 0) {
                    if (this.closed) {
                        throw new QueueClosedException();
                    }
                    try {
                        this.mutex.wait(timeout);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (this.closed) {
                    throw new QueueClosedException();
                }
                Object object = retval = this.head != null ? this.head.obj : null;
                if (retval == null) {
                    throw new TimeoutException();
                }
                if (retval == endMarker) {
                    this.close(false);
                    throw new QueueClosedException();
                }
                Object var6_5 = null;
            }
            catch (InterruptedException e) {
                Object var6_6 = null;
                this.mutex.release();
                return retval;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.mutex.release();
            throw throwable;
        }
        this.mutex.release();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean flush_entries) {
        if (flush_entries) {
            try {
                this.add(endMarker);
                ++this.num_markers;
                return;
            }
            catch (QueueClosedException closed) {
                // empty catch block
            }
            return;
        }
        try {
            try {
                block10: {
                    this.mutex.acquire();
                    this.closed = true;
                    try {
                        this.add_condvar.broadcast();
                        this.remove_condvar.broadcast();
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block10;
                        log.error((Object)("exception=" + e));
                    }
                }
                Object var4_5 = null;
            }
            catch (InterruptedException interruptedException) {
                Object var4_6 = null;
                this.mutex.release();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.mutex.release();
            throw throwable;
        }
        this.mutex.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        this.num_markers = 0;
        if (!this.closed) {
            this.close(false);
        }
        try {
            try {
                this.mutex.acquire();
                this.size = 0;
                this.head = null;
                this.tail = null;
                this.closed = false;
            }
            catch (InterruptedException interruptedException) {
                Object var3_2 = null;
                this.mutex.release();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mutex.release();
            throw throwable;
        }
        this.mutex.release();
    }

    public int size() {
        return this.size - this.num_markers;
    }

    public String toString() {
        return "Queue2 (" + this.size() + ") messages";
    }

    public String debug() {
        return this.toString() + ", head=" + this.head + ", tail=" + this.tail + ", closed()=" + this.closed() + ", contents=" + this.getContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getContents() {
        Vector<Object> retval = new Vector<Object>();
        try {
            try {
                this.mutex.acquire();
                Element el = this.head;
                while (el != null) {
                    retval.addElement(el.obj);
                    el = el.next;
                }
                Object var5_3 = null;
            }
            catch (InterruptedException interruptedException) {
                Object var5_4 = null;
                this.mutex.release();
                return retval;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mutex.release();
            throw throwable;
        }
        this.mutex.release();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilEmpty(long timeout) throws QueueClosedException, TimeoutException {
        long time_to_wait = timeout >= 0L ? timeout : 0L;
        try {
            try {
                this.mutex.acquire();
                if (timeout == 0L) {
                    while (this.size > 0 && !this.closed) {
                        this.remove_condvar.await();
                    }
                } else {
                    long start_time = System.currentTimeMillis();
                    while (time_to_wait > 0L && this.size > 0 && !this.closed) {
                        try {
                            this.remove_condvar.timedwait(time_to_wait);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        time_to_wait = timeout - (System.currentTimeMillis() - start_time);
                    }
                    if (this.size > 0) {
                        throw new TimeoutException("queue has " + this.size + " elements");
                    }
                }
                if (this.closed) {
                    throw new QueueClosedException();
                }
                Object var9_6 = null;
            }
            catch (InterruptedException e) {
                Object var9_7 = null;
                this.mutex.release();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.mutex.release();
            throw throwable;
        }
        this.mutex.release();
    }

    private Object removeInternal() {
        if (this.head == null) {
            return null;
        }
        Element retval = this.head;
        this.head = this.head.next;
        if (this.head == null) {
            this.tail = null;
        }
        this.decrementSize();
        this.remove_condvar.broadcast();
        if (this.head != null && this.head.obj == endMarker) {
            this.closed = true;
        }
        retval.next = null;
        return retval.obj;
    }

    void decrementSize() {
        --this.size;
        if (this.size < 0) {
            this.size = 0;
        }
    }

    class Element {
        Object obj = null;
        Element next = null;

        Element(Object o) {
            this.obj = o;
        }

        public String toString() {
            return this.obj != null ? this.obj.toString() : "null";
        }
    }
}

