/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.AbstractVFSContext;
import org.jboss.virtual.plugins.context.jar.JarHandler;
import org.jboss.virtual.spi.VirtualFileHandler;

public class JarContext
extends AbstractVFSContext {
    private final VirtualFileHandler root;
    private final VirtualFile rootFile;

    public JarContext(URL rootURL) throws IOException, URISyntaxException {
        super(rootURL);
        this.root = this.createVirtualFileHandler(null, rootURL);
        this.rootFile = this.root.getVirtualFile();
    }

    public VirtualFileHandler getRoot() throws IOException {
        return this.root;
    }

    public VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        String name = url.toString();
        int index = name.indexOf(33);
        if (index != -1) {
            name = name.substring(0, index);
        }
        if ((index = name.lastIndexOf(47)) != -1 && index < name.length() - 1) {
            name = name.substring(index + 1);
        }
        return new JarHandler(this, parent, url, name);
    }

    protected void finalize() throws Throwable {
        if (this.rootFile != null) {
            this.rootFile.close();
        }
        super.finalize();
    }
}

