/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.classloading.plugins.PackageInfo;
import org.jboss.classloading.plugins.WrappingClassLoader;
import org.jboss.logging.Logger;

public class ClassLoading {
    private static final Logger log = Logger.getLogger((Class)ClassLoading.class);
    private static final Map primitives = new HashMap();
    private static Set systemPackages;

    public static Class loadClass(ClassLoader classLoader, String string) throws Exception {
        return ClassLoading.loadClass(false, null, classLoader, string);
    }

    public static Class loadClass(boolean bl, String string, ClassLoader classLoader, String string2) throws Exception {
        if (bl) {
            log.trace((Object)("Loading " + string + " class=" + string2 + " classloader=" + classLoader));
        }
        Class<?> clazz = (Class<?>)primitives.get(string2);
        try {
            if (clazz == null) {
                clazz = classLoader.loadClass(string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Class.forName(string2);
        }
        if (bl) {
            log.trace((Object)("Loaded " + string + " " + clazz + " classloader=" + clazz.getClassLoader()));
        }
        return clazz;
    }

    public static Set getClassLoaderSpecificPackages(ClassLoader classLoader) {
        Set set = ClassLoading.getClassLoaderPackages(classLoader);
        set.removeAll(ClassLoading.getSystemPackages());
        return set;
    }

    public static Set getSystemPackages() {
        if (systemPackages == null) {
            systemPackages = ClassLoading.getClassLoaderPackages(ClassLoader.getSystemClassLoader());
        }
        return systemPackages;
    }

    public static Set getClassLoaderPackages(ClassLoader classLoader) {
        PackageInfo packageInfo = classLoader instanceof PackageInfo ? (PackageInfo)((Object)classLoader) : new WrappingClassLoader(classLoader);
        Package[] packageArray = packageInfo.getPackages();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < packageArray.length; ++i) {
            hashSet.add(packageArray[i].getName());
        }
        return hashSet;
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    static {
        primitives.put("byte", Byte.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
    }
}

