/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.KernelFactory;
import org.jboss.kernel.plugins.AbstractKernelObject;
import org.jboss.kernel.spi.config.KernelConfig;

public abstract class AbstractBootstrap
extends AbstractKernelObject
implements Runnable {
    protected KernelConfig config;
    protected Kernel kernel;

    public KernelConfig getConfig() {
        Kernel.checkAccess();
        return this.config;
    }

    public void setConfig(KernelConfig kernelConfig) {
        Kernel.checkConfigure();
        this.config = kernelConfig;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void run() {
        try {
            this.bootstrap();
        }
        catch (RuntimeException runtimeException) {
            this.log.trace((Object)"RuntimeException during JBoss Kernel Bootstrap.", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            this.log.trace((Object)"Exception during JBoss Kernel Bootstrap.", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        catch (Error error) {
            this.log.trace((Object)"Error during JBoss Kernel Bootstrap.", (Throwable)error);
            throw error;
        }
        catch (Throwable throwable) {
            this.log.trace((Object)"Error during JBoss Kernel Bootstrap.", throwable);
            throw new RuntimeException("Error during JBoss Kernel Bootstrap", throwable);
        }
    }

    protected void bootstrap() throws Throwable {
        this.kernel = KernelFactory.newInstance(this.config);
    }
}

