/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.bootstrap.KernelInitializer;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.logging.Logger;

public class KernelFactory {
    private static final KernelFactory singleton = new KernelFactory();
    protected final Logger log = Logger.getLogger(this.getClass());

    private KernelFactory() {
    }

    public static Kernel newInstance(KernelConfig kernelConfig) {
        return singleton.assembleNewKernel(kernelConfig);
    }

    protected Kernel assembleNewKernel(KernelConfig kernelConfig) throws RuntimeException {
        long l = 0L;
        long l2 = 0L;
        this.log.debug((Object)"Starting JBoss Kernel construction...");
        l = System.currentTimeMillis();
        boolean bl = this.log.isTraceEnabled();
        if (bl) {
            this.log.trace((Object)("Using KernelConfig: " + kernelConfig));
        }
        Kernel kernel = this.createKernel();
        if (bl) {
            this.log.trace((Object)("Using Kernel: " + kernel));
        }
        KernelInitializer kernelInitializer = this.createKernelInitializer(kernelConfig);
        if (bl) {
            this.log.trace((Object)("Using KernelInitializer: " + kernelInitializer));
        }
        this.configureKernel(kernel, kernelConfig);
        if (bl) {
            this.log.trace((Object)"Configured kernel from KernelConfig");
        }
        this.initializeKernel(kernel, kernelInitializer);
        if (bl) {
            this.log.trace((Object)"Kernel instance initialzed");
        }
        l2 = System.currentTimeMillis();
        this.log.debug((Object)("Completed JBoss Kernel construction.  Duration: " + (l2 - l) + " milliseconds"));
        return kernel;
    }

    protected Kernel createKernel() {
        return new Kernel();
    }

    protected KernelInitializer createKernelInitializer(KernelConfig kernelConfig) {
        try {
            return kernelConfig.createKernelInitializer();
        }
        catch (Throwable throwable) {
            String string = "Unable to create a KernelInitializer based on the specified KernelConfig";
            throw new RuntimeException(string, throwable);
        }
    }

    protected void configureKernel(Kernel kernel, KernelConfig kernelConfig) {
        kernel.setConfig(kernelConfig);
        try {
            kernelConfig.setKernel(kernel);
        }
        catch (Throwable throwable) {
            String string = "Unable to update the KernelConfig with the specified Kernel";
            throw new RuntimeException(string, throwable);
        }
    }

    protected void initializeKernel(Kernel kernel, KernelInitializer kernelInitializer) {
        try {
            kernelInitializer.initKernel(kernel);
        }
        catch (Throwable throwable) {
            String string = "Unable to properly initialize the Kernel";
            throw new RuntimeException(string, throwable);
        }
    }
}

