//$Id: MethodContext.java 2990 2006-12-14 10:27:00Z gavin $
package org.jboss.seam.core;

import static org.jboss.seam.InterceptionType.NEVER;
import static org.jboss.seam.annotations.Install.BUILT_IN;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;

/**
 * Support for injecting the page context
 * 
 * @author Gavin King
 */
@Scope(ScopeType.APPLICATION)
@Intercept(NEVER)
@Name("org.jboss.seam.core.methodContext")
@Install(precedence=BUILT_IN)
public class MethodContext
{
   @Unwrap
   public Context getContext()
   {
      return Contexts.isMethodContextActive() ? 
            Contexts.getMethodContext() : null;
   }
}
