/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jaccpropagation;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;

import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsersRolesLoginModule;

import org.jboss.security.auth.callback.SecurityAssociationCallback;

/** 
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 */
public class CustomLoginModule extends UsersRolesLoginModule
{
   private static Logger log = Logger.getLogger(CustomLoginModule.class);
   
   // This returns the propagated Principal
   protected Principal getCallbackPrincipal()
   {
      PasswordCallback pc = new PasswordCallback("Password: ", false);
      SecurityAssociationCallback sc = new SecurityAssociationCallback();
      NameCallback nc = new NameCallback("User name: ", "guest");

      Callback[] callbacks = {nc, pc, sc};
      
      Principal p = null;

      try
      {
         callbackHandler.handle(callbacks);
         
         p = sc.getPrincipal();
         
         if (p instanceof SimplePrincipal)
         {
            p = new CustomPrincipalImpl(p.getName());
            SecurityAssociation.setPrincipal(p);
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
        
      return p;
   }
   
   public void initialize(Subject subject, CallbackHandler callbackHandler,
      Map sharedState, Map options)
   {
      super.initialize(subject, callbackHandler, sharedState, options);
   }

   public boolean login() throws LoginException
   {
      boolean success = super.login();
      return success;
   }
   
   protected Principal createIdentity(String username)
      throws Exception
   { 
	   Principal p = null;
      if( principalClassName == null )
      {
         p = new SimplePrincipal(username);
      }
      else
      {
         ClassLoader loader = Thread.currentThread().getContextClassLoader();
         Class clazz = loader.loadClass(principalClassName);
         Class[] ctorSig = {String.class};
         Constructor ctor = clazz.getConstructor(ctorSig);
         Object[] ctorArgs = {username};
         p = (Principal) ctor.newInstance(ctorArgs);
      }
      
      return p;
   }
   
   protected Principal getIdentity()
   { 
      Principal p = null;
      
      if (getCallbackPrincipal() != null)
      {
         p = getCallbackPrincipal();
      }
      else
      {
         p = super.getIdentity();
      }
      
      return p;
   }
   
   public boolean commit() throws LoginException
   {
      return super.commit();
   }

   public boolean abort() throws LoginException
   {
      return super.abort();
   }
   
   public boolean logout() throws LoginException
   {
      return super.logout();
   }
  
   protected Group[] getRoleSets() throws LoginException
   {
      Group[] groups = super.getRoleSets();
      
      for (Group group : groups)
      {
         if (group.getName().equals("Roles"))
         {
            CustomPrincipalImpl customPrincipal = (CustomPrincipalImpl)getIdentity();
            if (customPrincipal.getCustomRole() != null && customPrincipal.getCustomRole().length() > 0){
               group.addMember(new CustomPrincipalImpl(customPrincipal.getCustomRole()));
            }
         }
      }
        
      return groups;
   }
   
   protected boolean getUseFirstPass()
   {
      boolean result = super.getUseFirstPass();
  
      return result;
   }
   
   protected Principal getUnauthenticatedIdentity()
   {
      return super.getUnauthenticatedIdentity();
   }
   
   protected Group createGroup(String name, Set principals)
   {
      Group group = super.createGroup(name, principals);
       
      return group;
   }
}
