/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.externalpersistenceunit.unit;

import org.jboss.ejb3.test.externalpersistenceunit.Entity1;
import org.jboss.ejb3.test.externalpersistenceunit.EntityTest;

import org.jboss.logging.Logger;
import org.jboss.test.JBossTestCase;
import junit.framework.Test;

/**
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 */
public class ExternalPUTestCase
extends JBossTestCase
{
   private static final Logger log = Logger.getLogger(ExternalPUTestCase.class);

   public ExternalPUTestCase(String name)
   {
      super(name);
   }

   public void testJPAPersistenceUnits() throws Exception
   {
      EntityTest test = (EntityTest) getInitialContext().lookup("JPATestBean/remote");
      
      Entity1 entity1 = new Entity1();
      entity1.setData("ONE");
      Long id1 = test.persistEntity1(entity1);
      
      entity1 = test.loadEntity1(id1);
      assertEquals("ONE", entity1.getData());
      
      test.remove();
      
      System.out.println("************ sleeping ...");     
      Thread.sleep(60 * 1000);
      
      test = (EntityTest) getInitialContext().lookup("JPATestBean/remote");
      
      entity1 = new Entity1();
      entity1.setData("TWO");
      id1 = test.persistEntity1(entity1);
   }
   
   public void atestEJB3PersistenceUnits() throws Exception
   {
      EntityTest test = (EntityTest) getInitialContext().lookup("EntityTestBean/remote");
      
      Entity1 entity1 = new Entity1();
      entity1.setData("ONE");
      Long id1 = test.persistEntity1(entity1);
      
      entity1 = test.loadEntity1(id1);
      assertEquals("ONE", entity1.getData());
   }

   public static Test suite() throws Exception
   {
//      return getDeploySetup(ExternalPUTestCase.class, "externalpersistenceunit-pu.jar, externalpersistenceunit-test.jar");
      return getDeploySetup(ExternalPUTestCase.class, "externalpersistenceunit-test.jar");
   }

}
