/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.externalpersistenceunit;

import java.util.HashMap;

import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;

import org.jboss.logging.Logger;


/**
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 */
@Stateful
@Remote(EntityTest.class)
@TransactionManagement(TransactionManagementType.BEAN)
public class JPATestBean implements EntityTest
{
   private static final Logger log = Logger.getLogger(JPATestBean.class);
   
   @Resource UserTransaction tx;
   
   protected EntityManagerFactory factory = Persistence.createEntityManagerFactory("Entity1");
   protected EntityManager manager = factory.createEntityManager();
    
   public Long persistEntity1(Entity1 entity1)
   {   
      try
      {
         tx.begin();
         manager.joinTransaction(); 
      
         manager.persist(entity1);
         tx.commit();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         try
         {
            tx.rollback();
         }
         catch (Exception se)
         {
            e.printStackTrace();
         }
      }
      
      return entity1.getId();
   }

   public Entity1 loadEntity1(Long id)
   {  
      Entity1 entity1 = null;
      
      try
      {
         tx.begin();
         manager.joinTransaction(); 
         
         entity1 = manager.find(Entity1.class, id);
         
         tx.commit();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         try
         {
            tx.rollback();
         }
         catch (Exception se)
         {
            e.printStackTrace();
         }
      }
      
      return entity1;
   }
   
   @Remove
   public void remove()
   {
      manager.close();
      factory.close();
   }
}
