<?xml version='1.0'?>
<!-- Transform a JBoss MQ deployment descriptor into a JBoss Messaging one -->
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>
   
   <xsl:output method="xml" indent="yes"/>
   
   <xsl:template match="/">
      <xsl:element name="server">
         <xsl:apply-templates/>
      </xsl:element>
   </xsl:template>
   
   <xsl:template match="mbean">
      <xsl:choose>
         <!-- only transform mq mbeans -->
         <xsl:when test="starts-with(@code,'org.jboss.mq.server.jmx')">
            <xsl:element name="mbean">
               <!-- set destionationType to either Topic or Queue -->
               <xsl:variable name="destinationType" select="substring-after(@code,'jmx.')"/>
               
               <!-- TODO: is name always the last part? -->
               <xsl:variable name="destinationName" select="substring-after(@name,'name=')"/>
               
               <xsl:attribute name="code">
                  <xsl:value-of select="concat('org.jboss.jms.server.destination.',$destinationType,'Service')"/>
               </xsl:attribute>
               
               <xsl:attribute name="name">
                  <xsl:value-of select="concat('jboss.messaging.destination:service=',$destinationType,',name=',$destinationName)"/>
               </xsl:attribute>
               
               <xsl:attribute name="xmbean-dd">
                  <xsl:value-of select="concat('xmdesc/',$destinationType,'-xmbean.xml')"/>
               </xsl:attribute>
               
               <xsl:apply-templates/>
            </xsl:element>
         </xsl:when>
         <!-- copy in any other mbeans -->
         <xsl:otherwise>
            <xsl:copy-of select="."/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   
   <!-- rename attribute SecurityConf to SecurityConfig -->
   <xsl:template match="attribute[@name='SecurityConf']">
      <xsl:element name="attribute">
         <xsl:attribute name="name">SecurityConfig</xsl:attribute>
         <xsl:copy-of select="*"/>
      </xsl:element>
   </xsl:template>
   
   <!-- copy in all attributes specified on the mq mbean -->
   <xsl:template match="attribute">
      <xsl:copy-of select="."/>
   </xsl:template>
   
   <!-- change the destination manager -->
   <xsl:template match="depends[@optional-attribute-name='DestinationManager']">
      <xsl:element name="depends">
         <xsl:attribute name="optional-attribute-name">
            <xsl:text>ServerPeer</xsl:text>
         </xsl:attribute>
         <xsl:text>jboss.messaging:service=ServerPeer</xsl:text>
      </xsl:element>
      <xsl:text>
      </xsl:text>
      <xsl:element name="depends">
         <xsl:text>jboss.messaging:service=PostOffice</xsl:text>
      </xsl:element>
   </xsl:template>

   <!-- ignore any remaining depends -->
   <xsl:template match="depends"/>
</xsl:transform>